#' Anthropometric data from college-aged women
#'
#' Percentage of body fat, age, weight, height, body mass index and fourteen
#' circumference measurements are given for 184 college women ages 18-25.
#' Body fat was accurately determined by an underwater weighing technique
#' which requires special equipment and training of the individuals
#' conducting the process. Circumference measurements were made to the
#' nearest 0.1 cm using a cloth tape in complete contact with the skin
#' but without compression of the soft tissues. The measurement process,
#' described somewhat incompletely below, is described in greater detail in
#' Slack (1997) who used the standards recommended by Lohman, Roche and
#' Martrell (1988).
#'
#'
#' @docType data
#'
#' @usage data(Anthro_F)
#'
#' @format A data.frame with one row for each of 184 woman
#'
#' - Weight (kg)
#' - Height (m)
#' - BMI: (Body Mass Index) Weight divided by the square of Height
#' - Age
#' - Neck: Minimal circumference perpendicular to the long axis of the neck (cm)
#' - Chest: Horizontal plane measurement at the sixth rib, at the end of a normal expiration (cm)
#' - Calf: Horizontal maximal calf measurement (cm)
#' - Biceps: Measurement with arm extended (cm)
#' - Hips: Horizontal maximal measurement around buttocks (cm)
#' - Waist: Horizontal minimal measurement, at the end of a normal expiration (cm)
#' - Forearm: Maximal measurement perpendicular to long axis (cm)
#' - PThigh: (Proximal Thigh) Horizontal measurement immediately distal to the gluteal furrow (cm)
#' - MThigh: (Middle Thigh) Measurement midway between the midpoint of the inguinal crease and the proximal border of the patella (cm)
#' - DThigh: (Distal Thigh) Measurement proximal to the femoral epicondyles (cm)
#' - Wrist: Measurement perpendicular to the long axis of the forearm (cm)
#' - Knee: Measurement at the mid-patellar level, with the knee slightly flexed (cm)
#' - Elbow: A minimal circumference measurement with the elbow extended (cm)
#' - Ankle: Minimal circumference measurement perpendicular to the long axis of the calf (cm)
#' - BFat: Amount of body fat expressed as a percentage of total body weight, using Siri's (1956) method
#'
#'
#' @keywords datasets
#'
#' @source Roger W. Johnson (2021) "Fitting Percentage of Body Fat to Simple Body Measurements: College Women"
#' *Journal of Statistics and Data Science Education* **29**(3) \doi{10.1080/26939169.2021.1971585}
"Anthro_F"
