% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LST_terra.R
\name{NDVI}
\alias{NDVI}
\title{NDVI}
\usage{
NDVI(Red, NIR)
}
\arguments{
\item{Red}{SpatRaster object, red band of remote sensing imagery}

\item{NIR}{SpatRaster object, NIR band of remote sensing imagery}
}
\value{
SpatRaster
}
\description{
Function for NDVI calculation
}
\examples{
red <- terra::rast(ncol=100, nrow=100)
set.seed(2)
terra::values(red) = runif(10000, min=0.1, max=0.4)

NIR <- terra::rast(ncol=100, nrow=100)
set.seed(2)
terra::values(NIR) = runif(10000, min=0.1, max=0.6)

NDVI(Red = red, NIR = NIR)
}
