% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LLM_parallel_utils.R
\name{setup_llm_parallel}
\alias{setup_llm_parallel}
\title{Setup Parallel Environment for LLM Processing}
\usage{
setup_llm_parallel(workers = NULL, strategy = NULL, verbose = FALSE)
}
\arguments{
\item{workers}{Integer. Number of workers to use. If NULL, auto-detects optimal number
(availableCores - 1, capped at 8). If called as \code{setup_llm_parallel(4)},
the single numeric positional argument is interpreted as \code{workers}.}

\item{strategy}{Character. The future strategy to use. Options: "multisession", "multicore", "sequential".
If NULL (default), automatically chooses "multisession".}

\item{verbose}{Logical. If TRUE, prints setup information.}
}
\value{
Invisibly returns the previous future plan.
}
\description{
Convenience function to set up the future plan for optimal LLM parallel processing.
Automatically detects system capabilities and sets appropriate defaults.
}
\examples{
\dontrun{
  # Automatic setup
  setup_llm_parallel()

  # Manual setup with specific workers
  setup_llm_parallel(workers = 4, verbose = TRUE)

  # Force sequential processing for debugging
  setup_llm_parallel(strategy = "sequential")

  # Restore old plan if needed
  reset_llm_parallel()
}
}
