% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ptMCMC.R
\name{step_chains}
\alias{step_chains}
\alias{propose_step}
\alias{eval_step}
\alias{take_step}
\title{Conduct a within-chain step of the ptMCMC algorithm}
\usage{
step_chains(i, cpts, inputs)

propose_step(i, cpts, inputs)

eval_step(i, cpts, prop_step, inputs)

take_step(cpts, prop_step, accept_step)
}
\arguments{
\item{i}{\code{integer} iteration index.}

\item{cpts}{\code{matrix} of change point locations across chains.}

\item{inputs}{Class \code{ptMCMC_inputs} \code{list}, containing the 
static inputs for use within the ptMCMC algorithm.}

\item{prop_step}{Proposed step output from \code{propose_step}.}

\item{accept_step}{\code{logical} indicator of acceptance of each chain's
proposed step.}
}
\value{
\code{step_chains}: \code{list} of change points, log-likelihoods, 
  and logical indicators of acceptance for each chain. \cr \cr
  \code{propose_step}: \code{list} of change points and 
  log-likelihood values for the proposal. \cr \cr
  \code{eval_step}: \code{logical} vector indicating if each 
  chain's proposal was accepted. \cr \cr
  \code{take_step}: \code{list} of change points, log-likelihoods, 
  and logical indicators of acceptance for each chain.
}
\description{
This set of functions steps the chains forward one iteration 
  of the within-chain component of the ptMCMC algorithm. \code{step_chains}
  is the main function, comprised of a proposal (made by \code{prop_step}),
  an evaluation of that proposal (made by \code{eval_step}), and then an 
  update of the configuration (made by \code{take_step}). 
  \cr \cr
  This set of functions was designed to work within \code{\link{TS}} and 
  specifically \code{\link{est_changepoints}}. They are still hardcoded to
  do so, but have the capacity to be generalized to work with any 
  estimation via ptMCMC with additional coding work.
}
\details{
For each iteration of the ptMCMC algorithm, all of the chains
  have the potential to take a step. The possible step is proposed under
  a proposal distribution (here for change points we use a symmetric
  geometric distribution), the proposed step is then evaluated and either
  accepted or not (following the Metropolis-Hastings rule; Metropolis,
  \emph{et al.} 1953, Hasting 1960, Gupta \emph{et al.} 2018), and then
  accordingly taken or not (the configurations are updated).
}
\examples{
\donttest{
  data(rodents)
  document_term_table <- rodents$document_term_table
  document_covariate_table <- rodents$document_covariate_table
  LDA_models <- LDA_set(document_term_table, topics = 2)[[1]]
  data <- document_covariate_table
  data$gamma <- LDA_models@gamma
  weights <- document_weights(document_term_table)
  data <- data[order(data[,"newmoon"]), ]
  saves <- prep_saves(1, TS_control())
  inputs <- prep_ptMCMC_inputs(data, gamma ~ 1, 1, "newmoon", weights, 
                               TS_control())
  cpts <- prep_cpts(data, gamma ~ 1, 1, "newmoon", weights, TS_control())
  ids <- prep_ids(TS_control())
  for(i in 1:TS_control()$nit){
    steps <- step_chains(i, cpts, inputs)
    swaps <- swap_chains(steps, inputs, ids)
    saves <- update_saves(i, saves, steps, swaps)
    cpts <- update_cpts(cpts, swaps)
    ids <- update_ids(ids, swaps)
  }
  # within step_chains()
  cpts <- prep_cpts(data, gamma ~ 1, 1, "newmoon", weights, TS_control())
  i <- 1
  prop_step <- propose_step(i, cpts, inputs)
  accept_step <- eval_step(i, cpts, prop_step, inputs)
  take_step(cpts, prop_step, accept_step)
}

}
\references{
Gupta, S., L. Hainsworth, J. S. Hogg, R. E. C. Lee, and J. R. Faeder. 
  2018. Evaluation of parallel tempering to accelerate Bayesian parameter
  estimation in systems biology. 
  \href{https://arxiv.org/abs/1801.09831}{link}.

  Hastings, W. K. 1970. Monte Carlo sampling methods using Markov Chains
  and their applications. \emph{Biometrika} \strong{57}:97-109.
  \href{https://academic.oup.com/biomet/article-abstract/57/1/97/284580}{link}.
 
  Metropolis, N., A. W. Rosenbluth, M. N. Rosenbluth, A. H. Teller, and E.
  Teller. 1953. Equations of state calculations by fast computing machines.
  \emph{Journal of Chemical Physics} \strong{21}: 1087-1092.
  \href{https://bayes.wustl.edu/Manual/EquationOfState.pdf}{link}.
}
