% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_DAG.R
\name{get_DAG}
\alias{get_DAG}
\title{get_DAG}
\usage{
get_DAG(X0, sparse = FALSE, twoway = FALSE)
}
\arguments{
\item{X0}{a numeric matrix.}

\item{sparse}{logical. Either the induced DAG (\code{FALSE}) or the induced
polyforest (\code{TRUE}) is constructed.}

\item{twoway}{logical. If \code{FALSE}, only leaves, parents, ancestors
and reverse topological ordering are returned. If TRUE, then roots, children
and descendants are also provided.}
}
\value{
A list with named elements giving the leaves, parents, ancestors and
reverse topological ordering and additionally, if \code{twoway == TRUE}, the
roots, children and descendants, of the constructed graph.
}
\description{
This function is used to construct the induced DAG, induced polyforest and
reverse topological orderings thereof from a numeric matrix \code{X0}. See
Definition 2 in \insertCite{MRCS2023;textual}{ISS}.
}
\examples{
X <- rbind(
  c(0.2, 0.8), c(0.2, 0.8), c(0.1, 0.7),
  c(0.2, 0.1), c(0.3, 0.5), c(0.3, 0)
)
get_DAG(X0 = X)
get_DAG(X0 = X, sparse = TRUE, twoway = TRUE)

}
\references{
\insertRef{MRCS2023}{ISS}
}
