% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dag_test_FS.R
\name{dag_test_FS}
\alias{dag_test_FS}
\title{dag_test_FS}
\usage{
dag_test_FS(p_order, p, alpha, decreasing = FALSE)
}
\arguments{
\item{p_order}{a numeric vector or matrix with one column whose order determines the sequence of tests.}

\item{p}{a numeric vector taking values in (0, 1] such that \code{length(p) == nrow(p_order)} if p_order is a matrix (or \code{length(p) == length(p_order)} if p_order is a numeric vector).}

\item{alpha}{a numeric value in (0, 1] specifying the Type I error rate.}

\item{decreasing}{a boolean value determining whether the order of p_order should be understood in decreasing order.}
}
\value{
A boolean vector of the same length as \code{p} with each element being \code{TRUE} if the corresponding hypothesis is rejected and \code{FALSE} otherwise.
}
\description{
Implements the fixed sequence testing procedure of familywise error rate control. The sequence is given through ordering elements of \code{p_order} increasingly.
}
\examples{
p_order <- c(0.5, 0, 1)
p <- c(0.01, 0.1, 0.05)
alpha <- 0.05
dag_test_FS(p_order, p, alpha, decreasing = TRUE)

}
