% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotIndVar.R
\name{plotIndVar}
\alias{plotIndVar}
\title{Plot individual variability in the IAT}
\usage{
plotIndVar(my_data, block_name, trial_blocks, session_id, trial_latency,
  trial_error)
}
\arguments{
\item{my_data}{The raw dataframe to be used}

\item{block_name}{A string of the variable name for the blocks}

\item{trial_blocks}{A vector of the four essential blocks in the seven-block IAT (i.e., B3, B4, B6, and B7).}

\item{session_id}{A string of the variable name identifying each unique participant.}

\item{trial_latency}{A string of the variable name for the latency of each trial.}

\item{trial_error}{A string of the variable name identifying whether a trial was an error or not (1 = error)}
}
\description{
Plot mean participant reaction time with 95\% confidence intervals to see how reaction time varies by participant. The data is automatically cleaned
(i.e., no error trials, trials with RT > 10000 or < 180 are deleted) to avoid over/underinflation of mean estimates and only includes trials from
essential blocks.
}

