% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_HypeMultiVar.R
\name{HypeMultiVar}
\alias{HypeMultiVar}
\title{HypeMultiVar arrays}
\usage{
HypeMultiVar(
  x,
  datetime,
  hype.var,
  hype.unit,
  subid = NULL,
  outregid = NULL,
  hype.comment = ""
)
}
\arguments{
\item{x}{numeric \code{\link{array}} with three dimensions, which holds HYPE results for one sub-basin as (in order)
\code{[datetime, variable, iteration]}.}

\item{datetime}{\code{\link{POSIXct}} date-time vector of the same length as \code{time} dimension of \code{x}
with equidistant time steps (starting day for time steps from weekly to annual), or character string for full model
period averages, e.g. \code{"2000-2010"}.}

\item{hype.var, hype.unit}{Character vectors of keywords to specify HYPE variable IDs, corresponding to second dimension
(columns) in \code{x}. See
\href{http://hype.smhi.net//wiki/doku.php?id=start:hype_file_reference:info.txt:variables}{list of HYPE variables}}

\item{subid}{Integer, HYPE sub-basin ID. Either this or \code{outregid} needs to be supplied.}

\item{outregid}{Integer, HYPE output region ID, alternative to \code{subid}.}

\item{hype.comment}{Character, first-row optional comment string of basin output file. Empty string, if non-existing.}
}
\value{
Returns a 3-dimensional array with
\code{[time, variable, iteration]} dimensions and additional \code{\link{attributes}}:
\describe{
\item{\strong{datetime}}{A vector of date-times. Corresponds to 1st array dimension.}
\item{\strong{variable}}{A character vector of HYPE output variable IDs.}
\item{\strong{hypeunit}}{A character vector of HYPE output variable units.}
\item{\strong{subid}}{A single SUBID.}
\item{\strong{outregid}}{A single OUTREGID.}
\item{\strong{timestep}}{A character keyword for the time step.}
\item{\strong{comment}}{A comment string, currently used for class group outputs.}
}
}
\description{
Constructor function for arrays which hold equidistant time series of multiple HYPE variables for a single sub-basin and
multiple model runs, typically imported HYPE basin output results.
}
\details{
S3 class constructor function for array objects which can hold (multiple) HYPE basin output results.
}
\examples{
# import a basin output file
te1 <- ReadBasinOutput(filename = system.file("demo_model",
"results", "0003587.txt", package = "HYPEtools"))
# create a dummy array with two iterations from imported basin file
te2 <- array(data = c(unlist(te1[, -1]),  unlist(te1[, -1])), 
             dim = c(nrow(te1), ncol(te1) - 1, 2), 
             dimnames = list(rownames(te1), colnames(te1)[-1]))
# Construct HypeMultiVar array
HypeMultiVar(te2, datetime = te1$DATE, hype.var = variable(te1),
hype.unit = hypeunit(te1), subid = 3587)

}
