% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_AllDownstreamSubids.R
\name{AllDownstreamSubids}
\alias{AllDownstreamSubids}
\title{Find All Downstream SUBIDs}
\usage{
AllDownstreamSubids(subid, gd, bd = NULL, write.arcgis = FALSE)
}
\arguments{
\item{subid}{Integer, SUBID of a target sub-catchment (must exist in \code{gd}).}

\item{gd}{Dataframe, an imported 'GeoData.txt' file. Mandatory argument. See 'Details'.}

\item{bd}{Dataframe, an imported 'BranchData.txt' file. Optional argument. See 'Details'.}

\item{write.arcgis}{Logical. If \code{TRUE}, a string containing an SQL expression suitable for ArcGIS's
'Select By Attributes' feature will be written to the clipboard.}
}
\value{
\code{AllDownstreamSubids} returns a vector of downstream SUBIDs to the outlet if no BranchData is provided, otherwise a data frame with
two columns \code{downstream} with downstream SUBIDs and \code{is.branch} with logical values indicating if a downstream SUBID contains a
bifurcation ('branch' in HYPE terms). Downstream SUBIDs are ordered from source to final outlet SUBID.
}
\description{
Function to find all SUBIDs of downstream sub-catchments along the main stem for a single
sub-catchment.
}
\details{
\code{AllDownstreamSubids} finds all downstream SUBIDs of a given SUBID along the main stem (including itself but not
including potential irrigation links or groundwater flows) using GeoData columns 'SUBID' and 'MAINDOWN'. If a BranchData file
is provided, the function will also include information on downstream bifurcations.
}
\examples{
te <- ReadGeoData(filename = system.file("demo_model", "GeoData.txt", package = "HYPEtools"))
AllDownstreamSubids(subid = 3344, gd = te)

}
\seealso{
\code{\link{AllUpstreamSubids}}, \code{\link{OutletSubids}}, \code{\link{OutletIds}}
}
