% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flex_accuracy_diff.R
\name{flex_accuracy_diff}
\alias{flex_accuracy_diff}
\title{flex_accuracy_diff function}
\usage{
flex_accuracy_diff(
  accuracy_data,
  comparison_data,
  interactive = TRUE,
  user_colors = NULL,
  user_segment_color = "darkblue",
  display_p_values = TRUE,
  models_to_display_p_values = NULL,
  user_title = "Prediction Accuracy Comparison Plot",
  user_x_title = "Model",
  user_y_title = "Prediction Accuracy",
  user_legend_title = NULL,
  user_plot_theme = theme_minimal(),
  user_plot_theme_specs = theme(legend.title = element_text(size = 10), legend.text =
    element_text(size = 15), title = element_text(size = 15), axis.text.x =
    element_text(size = 10), axis.title.x = element_text(size = 10), axis.text.y =
    element_text(size = 10), axis.title.y = element_text(size = 10)),
  user_p_value_prefix = NULL,
  user_bar_width = 0.8,
  geom_text_args = list(),
  additional_ggplot_args = list()
)
}
\arguments{
\item{accuracy_data}{A data frame containing the models' R-squared values
with two columns: 'Model' and 'R_squared'}

\item{comparison_data}{A data frame containing pairwise comparisons with
three columns: 'Compare1', 'Compare2' and 'p_value'}

\item{interactive}{Logical. If 'TRUE', returns an interactive plotly object;
otherwise, returns a static ggplot object. Default is 'TRUE'.}

\item{user_colors}{Character vector of colors for the bars. If 'NULL', uses
ggplot2 default colors. Default is 'NULL'.}

\item{user_segment_color}{Character. Color of comparison lines and dashed
segments. Default is "darkblue"'.}

\item{display_p_values}{Logical. If 'TRUE', adds p-values to the plot for
specified comparisons. Default is 'TRUE'.}

\item{models_to_display_p_values}{Character vector of model pairs for which
p-values should be displayed, formatted as "Model1 Model2"'. Default is
'NULL'.}

\item{user_title}{Character. Title of the plot. Default is "Prediction
Accuracy Comparison Plot"'.}

\item{user_x_title}{Character. Title of the x-axis. Default is "Model"'.}

\item{user_y_title}{Character. Title of the y-axis. Default is "Prediction
Accuracy"'.}

\item{user_legend_title}{Character. Title of the legend. Default is 'NULL'.}

\item{user_plot_theme}{A ggplot2 theme to be applied to the plot. Default is
'theme_minimal()'.}

\item{user_plot_theme_specs}{Additional theme specifications applied after
'user_plot_theme'. Default is a set of predefined theme customizations.}

\item{user_p_value_prefix}{Character. Prefix to be added before displaying
p-values. Default is 'NULL'.}

\item{user_bar_width}{Numeric. Width of the bars. Default is '0.8'.}

\item{geom_text_args}{List. Additional arguments for 'geom_text', such as
color, font size, or angle. Default is an empty list.}

\item{additional_ggplot_args}{List. Additional ggplot2 layers or arguments
to be added to the plot. Default is an empty list.}
}
\value{
A ggplot object if 'interactive' is FALSE; otherwise, an interactive
Plotly plot.
}
\description{
This function generates a customizable bar plot to compare prediction
accuracy (e.g. R-squared values) between multiple models.
It displays pairwise comparison lines and corresponding p-values. Interactive
plots can be created using Plotly.
}
\examples{
library(ggplot2)
library(plotly)
library(dplyr)
library(nortest)
library(ggforce)
library(reshape2)
library(gridExtra)
library(grid)
library(cowplot)
accuracy_data <- example_data4
comparison_data <- example_data5
# Create a static plot
flex_accuracy_diff(accuracy_data, comparison_data, interactive = FALSE)

# Create an interactive plot
flex_accuracy_diff(accuracy_data, comparison_data)

# Display specific p-values
flex_accuracy_diff(accuracy_data, comparison_data, 
  models_to_display_p_values = c("Model A Model B"))
}
