% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fun_export.R
\name{shrink_estim}
\alias{shrink_estim}
\title{Shrinkage of the covariance matrix}
\usage{
shrink_estim(x, mse = TRUE)
}
\arguments{
\item{x}{A numeric matrix containing the in-sample residuals.}

\item{mse}{If \code{TRUE} (\emph{default}), the residuals used to compute the covariance
matrix are not mean-corrected.}
}
\value{
A shrunk covariance matrix.
}
\description{
Shrinkage of the covariance matrix according to \enc{Schäfer}{Schafer} and Strimmer (2005).
}
\references{
\enc{Schäfer}{Schafer}, J.L. and Strimmer, K. (2005), A shrinkage approach to large-scale
covariance matrix estimation and implications for functional genomics,
\emph{Statistical Applications in Genetics and Molecular Biology}, 4, 1
}
\seealso{
Utilities: 
\code{\link{FoReco2matrix}()},
\code{\link{aggts}()},
\code{\link{balance_hierarchy}()},
\code{\link{commat}()},
\code{\link{csprojmat}()},
\code{\link{cstools}()},
\code{\link{ctprojmat}()},
\code{\link{cttools}()},
\code{\link{df2aggmat}()},
\code{\link{lcmat}()},
\code{\link{recoinfo}()},
\code{\link{res2matrix}()},
\code{\link{set_bounds}()},
\code{\link{shrink_oasd}()},
\code{\link{teprojmat}()},
\code{\link{tetools}()},
\code{\link{unbalance_hierarchy}()}
}
\concept{Utilities}
