% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fluidigm2PLINK.R
\name{fluidigm2PLINK}
\alias{fluidigm2PLINK}
\title{Convert Fluidigm Output to 'PLINK' Format}
\usage{
fluidigm2PLINK(
  file = NA,
  map = NA,
  out = NA,
  outdir = NA,
  plots = TRUE,
  rearrange = TRUE,
  missing.geno = "0 0",
  fixNames = TRUE,
  overwrite = FALSE,
  verbose = TRUE,
  verbosity = 1
)
}
\arguments{
\item{file}{A string specifying the path to the input file in CSV format.}

\item{map}{A string specifying the filepath to the map-file that should be used.}

\item{out}{A string specifying the output file name. If left empty, the original basename of the input file will be used.}

\item{outdir}{A string specifying the output folder. If left empty the original folder path of the input file will be used.}

\item{plots}{A logical indicating whether additional figures for conversion should be plotted. Default is TRUE.}

\item{rearrange}{A logical indicating whether the ped/map output should be rearranged in order of provided map file. Default is TRUE.}

\item{missing.geno}{A character string specifying how missing values should be coded. Default is "0 0".}

\item{fixNames}{A logical indicating whether whitespaces from sample names should be automatically removed. Default is TRUE.}

\item{overwrite}{A logical indicating wheter the original map file should be overwritten or not. Default FALSE}

\item{verbose}{A logical or numerical value indicating whether the output should be verbose. Default is TRUE.}

\item{verbosity}{A numerical value indicating the level of verbosity. Set to a higher number for more details. Default is 1.}
}
\value{
A ped/map file pair and optional diagnostic plots.
}
\description{
This function takes a Fluidigm output file and converts it into a 'PLINK' format. The 'PLINK' ped/map format is a widely used genetic
variation data format. This function is useful for researchers who want to analyze Fluidigm data using tools that accept
'PLINK' format.
}
\details{
The function first checks the input parameters and then imports the Fluidigm data from the CSV file. It creates a new MAP file
based on the information provided in the given map file. The function then creates a PED file and exports both files.
If requested, the function also generates plots for genotyping success and additional summary statistics.

This function uses the PLINK software. For more information about PLINK, please refer to the official documentation.
}
\examples{
  file_path_csv <- system.file("extdata", "example_data.csv", package = "Fluidigm")
  file_path_map <- system.file("extdata", "example_data_withY.map", package = "Fluidigm")
  outdir <- tempdir()

  fluidigm2PLINK(file=file_path_csv, map=file_path_map, outdir=outdir)

}
\references{
PLINK: Whole genome data analysis toolset - Harvard University
}
