% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPhotoInfo.R
\name{getPhotoInfo}
\alias{getPhotoInfo}
\alias{get_photo_info}
\title{Get available information for a Flickr photo.}
\usage{
getPhotoInfo(
  api_key = NULL,
  photo_id,
  output = c("location", "date", "url", "tags")
)

get_photo_info(
  api_key = NULL,
  photo_id,
  output = c("location", "date", "url", "tags")
)
}
\arguments{
\item{api_key}{Flickr API key. If api_key is `NULL`, the function uses
[getFlickrAPIKey()] to use the environment variable "FLICKR_API_KEY" as the
key.}

\item{photo_id}{The id of the photo to get information for.}

\item{output}{Output data type. Supported options include "all", "location",
"date", "url" or "tags". If output = "all", the function returns a list
with all available data. Otherwise the function returns a data frame.}
}
\value{
This function returns data of specific photo's information.
}
\description{
R access to photo information of photos posted on Flickr via Flickr API.
}
\examples{
\dontrun{
getPhotoInfo(
  api_key = "XXXXXXXXXX",
  photo_id = "30484882493",
  output = "location"
)
}
}
\seealso{
\url{https://www.flickr.com/services/api/flickr.photos.getInfo.html}
}
