% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InferWald.R
\name{InferWald}
\alias{InferWald}
\title{Infer by the Wald test.}
\usage{
InferWald(Omega.inv, n, K, Y.vec, Gamma_e)
}
\arguments{
\item{Omega.inv}{Matrix, with size (2n)*(2n).}

\item{n}{Integer.}

\item{K}{Matrix, with size n*n.}

\item{Y.vec}{Matrix, with size (2*n)*1, the vectorized Y.}

\item{Gamma_e}{Matrix, with size 2*2.}
}
\value{
List,
the covariance matrix, which is the inverse of the Fisher information matrix, inferred by the Wald test,
the estimated off-diagonal element eta in the matrix Gamma_epsilon,
the standard error of eta,
the p-value of eta,
the estimated partial correlation rho,
the standard error of rho,
the p-value of rho.
}
\description{
Infer by the Wald test.
}
\examples{
\donttest{
InferWald(Omega.inv, n, K, Y.vec, Gamma_e)
}
}
