% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FlagOnePair.R
\name{FlagOnePair}
\alias{FlagOnePair}
\title{FLAG for one pair of random variables, using random effects model.
This is a repeated function for FLAG.}
\usage{
FlagOnePair(
  Y,
  X,
  Gamma_beta = NULL,
  Gamma_e = NULL,
  infer = "llr",
  fix.eta = FALSE,
  eps = 1e-07,
  max.iter = 5000,
  crit.loglik = 1e-04
)
}
\arguments{
\item{Y}{Matrix, with size n*2.}

\item{X}{Matrix, with size n*(p-2).}

\item{Gamma_beta}{Matrix, with size 2*2.}

\item{Gamma_e}{Matrix, with size 2*2.}

\item{infer}{Character, option of different tests of inference where 'llr' for likelihood ratio test and 'wald' for Wald test based on Fisher Information Matrix.}

\item{fix.eta}{Logical, whether to fix eta, default to be FALSE.}

\item{eps}{Numeric, a small term to avoid numerical problems, default to be 1e-7.}

\item{max.iter}{Integer, the maximum number of iterations, default to be 5000.}

\item{crit.loglik}{Numeric, the criteria of the change ratio of log likelihood to stop.}
}
\value{
List,
the list of log likelihood during iterations,
the estimated Gamma_beta matrix with size 2\emph{2, in the random effects model,
the estimated Gamma_epsilon matrix with size 2}2, in the random effects model,
the estimated 2*2 submatrix of the precision matrix,
the covariance matrix, which is the inverse of the Fisher information matrix, inferred by the Wald test,
the estimated off-diagonal element eta in the matrix Gamma_epsilon,
the standard error of eta,
the p-value of eta,
the estimated partial correlation rho,
the standard error of rho,
the p-value of rho.
}
\description{
FLAG for one pair of random variables, using random effects model.
This is a repeated function for FLAG.
}
\examples{
\donttest{
FlagOnePair(Y, X)
}
}
