% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_abc.R
\name{get_fft_df}
\alias{get_fft_df}
\title{Get FFT definitions (from an \code{FFTrees} object \code{x})}
\usage{
get_fft_df(x)
}
\arguments{
\item{x}{An \code{FFTrees} object.}
}
\value{
A set of FFT definitions (as a \code{data.frame}/\code{tibble},
in the one-line per FFT definition format used by an \code{FFTrees} object).
}
\description{
\code{get_fft_df} gets the FFT definitions
of an \code{FFTrees} object \code{x}
(as a \code{data.frame}).
}
\details{
The FFTs in the \code{data.frame} returned
are represented in the one-line per FFT definition format
used by an \code{FFTrees} object.

In addition to looking up \code{x$trees$definitions},
\code{get_fft_df} verifies that the FFT definitions
are valid (given current settings).
}
\seealso{
\code{\link{read_fft_df}} for reading one FFT definition from tree definitions;
\code{\link{write_fft_df}} for writing one FFT to tree definitions;
\code{\link{add_fft_df}} for adding FFTs to tree definitions;
\code{\link{FFTrees}} for creating FFTs from and applying them to data.

Other utility functions: 
\code{\link{get_best_tree}()},
\code{\link{get_exit_type}()}

Other tree definition and manipulation functions: 
\code{\link{add_fft_df}()},
\code{\link{add_nodes}()},
\code{\link{drop_nodes}()},
\code{\link{edit_nodes}()},
\code{\link{flip_exits}()},
\code{\link{read_fft_df}()},
\code{\link{reorder_nodes}()},
\code{\link{select_nodes}()},
\code{\link{write_fft_df}()}
}
\concept{tree definition and manipulation functions}
\concept{utility functions}
