% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Radiation.R
\name{JulDate}
\alias{JulDate}
\title{Julian Date}
\usage{
JulDate(date)
}
\arguments{
\item{date}{Optional. A character string that denotes the date in the format "Year-Month-Day" or "Year/Month/Day".}
}
\value{
The function returns Julian Date as a numeric scalar.
}
\description{
\code{JulDate} returns Julian Date.
}
\details{
This is a function to calculate Julian Date.
}
\section{Reference}{

\href{https://www.fao.org/3/x0490E/x0490e00.htm}{Allen, R. G., Pereira, L. S., Raes, D., & Smith, M. (1998).
   \emph{Crop evapotranspiration - Guidelines for computing crop water requirements - FAO Irrigation and drainage paper 56}.
   Fao, Rome, 300(9), D05109.}
}

\examples{
JulDate(date = "2020-06-25")
JulDate(date = "2020/06/25")

}
\seealso{
\code{\link{DH}, \link{EarSunDis}, \link{SolDec}}.
}
