% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/srna_filiter.R
\name{Rpmfilter}
\alias{Rpmfilter}
\title{Filtering out lowly expressed genes based on RPM}
\usage{
Rpmfilter(P1_RPM, P2_RPM, F1_RPM, type, homoeologs, rpm_threshold = 1)
}
\arguments{
\item{P1_RPM}{A data frame. The RPM table of genes in P1 species. For the RPM table, the first column is the gene identifier (e.g. sequences of sRNA, Gene ID), and other columns are the RPM values of the gene in each biological replicate.}

\item{P2_RPM}{A data frame. The RPM table of genes in P2 species.}

\item{F1_RPM}{A data frame. The RPM table of genes in F1 species.}

\item{type}{A character. "sRNA" or "mRNA".}

\item{homoeologs}{A data frame. Orthologous relationships of genes within the parental species and their progeny. Only required when the 'type' is 'mRNA'.}

\item{rpm_threshold}{A numeric. Threshold for filtering out the lowly expressed genes. The default is 1 (the average RPM of all replicates).}
}
\value{
A data frame.
}
\description{
Regarding the criteria for filtering out lowly expressed genes, no less than the RPM threshold in all replicates.
}
\details{
The 'homoeologs' table contains the orthologs pairs. In detail, the first column is the group name (unique) of homoeologs among three species (Parents: P1; P2, Progeny: F1), the second column is the Gene ID of P1, the third column is the Gene ID of P2. And the fourth column and fifth columns are the identifier of F1 orthologs derived from P1 and P2 ancestors, respectively (e.g. "Homoeolog1	BraA01t00004Z	BolC01g000040.2J BnA01g0000030.1 BnC01g0424620.1").
}
\examples{
Rpm1result <- Rpmfilter(P1_RPM = P1_miRNA_rpm,
                         P2_RPM = P2_miRNA_rpm,
                         F1_RPM = F1_miRNA_rpm,
                         type = "sRNA", rpm_threshold = 1)
}
