% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Get12Bins.R
\name{Get12Bins}
\alias{Get12Bins}
\title{Non-additive expression analysis}
\usage{
Get12Bins(
  P1_count,
  P2_count,
  F1_count,
  type,
  homoeologs,
  count_threshold = 5,
  Pvalue = 0.05,
  log2FC = 1
)
}
\arguments{
\item{P1_count}{A data frame. The count table of genes in P1 species. For the count table, the first column is the gene identifier, and other columns are the corresponding expression levels of the genes in each biological replicate.}

\item{P2_count}{A data frame. The count table of genes in P2 species.}

\item{F1_count}{A data frame. The count table of genes in F1 species.}

\item{type}{A character. "sRNA" or "mRNA".}

\item{homoeologs}{A data frame. Orthologous relationships of genes in the parental species and their progeny. Only required when the 'type' is 'mRNA'.}

\item{count_threshold}{A numeric. Threshold for filtering out the lowly expressed genes. The default is 5 (the count values in all replicates).}

\item{Pvalue}{A numeric. The P value of differential expression analysis using DESeq2. Default is 0.05.}

\item{log2FC}{A numeric. The log2-transformed expression fold of differential expression analysis using DESeq2. Default is 1.}
}
\value{
A data frame. Classification results of non-additive analysis based on the ELD method.
}
\description{
Rapp et al. proposed the classification of 12 expression patterns in allopolyploids, including additivity (I, XII), ELD (II, XI, IV, IX), transgressive down-regulation (III, VII, X) and transgressive up-regulation (V, VI, VIII).
}
\details{
pv11: P value of differential expression analysis using DESeq2. Parental P1 was used as the control group and F1 was used as the treatment group. pv12: P value of differential expression analysis using DESeq2. Parental P2 was used as the control group and F1 was used as the treatment group. pv21: P value of differential expression analysis using DESeq2. Parental P1 was used as the control group and P2 was used as the treatment group. Besides, "fc" represents the log2FoldChange of differential expression analysis.
}
\examples{
\donttest{
miRNA_12bin <- Get12Bins(P1_count = P1_miRNA_count,
                         P2_count = P2_miRNA_count,
                         F1_count = F1_miRNA_count,type = "sRNA")
}
}
\references{
Rapp RA, Udall JA, Wendel JF. Genomic expression dominance in allopolyploids. BMC Biol. 2009 May 1;7:18.
}
