#' Plot the actual and predicted daily milk production obtained by the ensemble model
#'
#' @param data The object generated by the LacCurveFit function
#' @param ID The ID of the individual whose daily milking records will be plotted
#' @param trait The name of the column containing the daily milking records
#' @param metric The name of the strategy used to obtain the predicted values through the ensemble model
#' @param dim The name of the column containing the days in milk (DIM) records
#' @param col A vector defining the colors for the actual and predicted values
#' @param point_size Numeric value indicating the size of the observed data points in the plot
#' @param line_size Numeric value indicating the thickness of the regression line
#' @param axis_text_size Numeric value defining the font size of the axis tick labels
#' @param axis_title_size Numeric value defining the font size of the axis titles
#' @importFrom ggplot2 ggplot aes geom_point geom_line geom_segment labs theme theme_minimal element_text
#' @return A plot showing the actual and predicted daily milk production across the days in milk
#' @export
PlotWeightLac<-function(data,ID, trait,metric,dim,col=c("red","blue"),point_size = 2, line_size = 1,axis_text_size = 15, axis_title_size = 15){

  data<-data$production[[ID]]

  data %>% ggplot2::ggplot() +
    geom_point(aes(x = .data[[dim]], y = .data[[trait]]), color = col[1] , size = 2) +
    geom_line(data = data, aes(x = .data[[dim]], y = .data[[metric]]), color = col[2], size = 1) +
    labs(title = "", x = "DIM", y = "Production") +
    theme_minimal() +
    theme(axis.text.x = element_text( size=15), axis.text.y = element_text(size=15), axis.title = element_text(size=15))

}
