% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/DyMEP_apply_unknown_environment_prediction_utils.R
\name{envpredutils.env_period_cutter}
\alias{envpredutils.env_period_cutter}
\title{A function to cut the environmental data into the correct length}
\usage{
envpredutils.env_period_cutter(
  start_date,
  env_variables,
  env_data,
  max_period_length = 300
)
}
\arguments{
\item{start_date}{start of the phase}

\item{env_variables}{name of the wanted variables}

\item{env_data}{actual environmental data}

\item{max_period_length}{in order to reduce computing time, a maximal
amount of days will be considered (default = 300); if less data available,
less days will be considered}
}
\value{
list with cut environmental covariates for the given period
}
\description{
A function to cut the environmental data into the correct length
}
\examples{
envpredutils.env_period_cutter(Sys.Date(),
c("tas"), list("tas"=data.frame("DATE"= seq(as.Date(Sys.Date()),
 (Sys.Date()+100),by="day"),
  "VALUE"= c(1:101))), 50)
}
\keyword{internal}
