% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_scatterplot.R
\name{plot_scatterplot}
\alias{plot_scatterplot}
\title{Create scatterplot for all features}
\usage{
plot_scatterplot(
  data,
  by,
  sampled_rows = nrow(data),
  geom_point_args = list(),
  geom_jitter_args = list(),
  scale_x = NULL,
  scale_y = NULL,
  title = NULL,
  ggtheme = theme_gray(),
  theme_config = list(),
  nrow = 3L,
  ncol = 3L,
  parallel = FALSE
)
}
\arguments{
\item{data}{input data}

\item{by}{feature name to be fixed at}

\item{sampled_rows}{number of rows to sample if data has too many rows. Default is all rows, which means do not sample.}

\item{geom_point_args}{a list of other arguments to \link[ggplot2]{geom_point}}

\item{geom_jitter_args}{a list of other arguments to \link[ggplot2]{geom_jitter}. If empty, \link[ggplot2]{geom_jitter} will not be added.}

\item{scale_x}{scale of original x axis (before \code{coord_flip}). See \link[ggplot2]{scale_x_continuous} for all options. Default is \code{NULL}.}

\item{scale_y}{scale of original y axis (before \code{coord_flip}). See \link[ggplot2]{scale_y_continuous} for all options. Default is \code{NULL}.}

\item{title}{plot title}

\item{ggtheme}{complete ggplot2 themes. The default is \link[ggplot2]{theme_gray}.}

\item{theme_config}{a list of configurations to be passed to \link[ggplot2]{theme}.}

\item{nrow}{number of rows per page}

\item{ncol}{number of columns per page}

\item{parallel}{enable parallel? Default is \code{FALSE}.}
}
\value{
invisibly return the named list of ggplot objects
}
\description{
This function creates scatterplot for all features fixing on a selected feature.
}
\examples{
plot_scatterplot(iris, by = "Species")

# Plot skewed data on log scale
set.seed(1)
skew <- data.frame(replicate(5L, rbeta(1000, 1, 5000)))
plot_scatterplot(skew, by = "X5", ncol = 2L)
plot_scatterplot(skew, by = "X5", scale_x = "log10",
scale_y = "log10", ncol = 2L)

# Plot with `geom_jitter`
plot_scatterplot(iris, by = "Species",
geom_jitter_args = list(width = NULL)) # Turn on with default settings
plot_scatterplot(iris, by = "Species",
geom_jitter_args = list(width = 0.1, height = 0.1))

\dontrun{
# Customize themes
library(ggplot2)
plot_scatterplot(
  data = mpg,
  by = "hwy",
  geom_point_args = list(size = 1L),
  theme_config = list("axis.text.x" = element_text(angle = 90)),
  ncol = 4L
)
}
}
\seealso{
\link[ggplot2]{geom_point}
}
\keyword{plot_scatterplot}
