% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/M_OEM.R
\name{M_OEM}
\alias{M_OEM}
\title{The M-OEM algorithm replaces M-step with stochastic step, which is used to solve the parameter estimation of Poisson mixture model.}
\usage{
M_OEM(y, K, alpha0, lambda0, a, b)
}
\arguments{
\item{y}{is a data vector}

\item{K}{is the number of Poisson distribution}

\item{alpha0}{is the initial value of the mixing weight}

\item{lambda0}{is the initial value of the mean}

\item{a}{represents the power of the reciprocal of the step size}

\item{b}{indicates that the M-step is not implemented for the first b data points}
}
\value{
M_OEMtime,M_OEMalpha,M_OEMlambda
}
\description{
The M-OEM algorithm replaces M-step with stochastic step, which is used to solve the parameter estimation of Poisson mixture model.
}
\examples{
library(stats)
set.seed(637351)
K=5 
alpha1=c(rep(1/K,K)) 
lambda1=c(1,2,3,4,5) 
n=300 
U=sample(c(1:n),n,replace=FALSE)
y= c(rep(0,n)) 
for(i in 1:n){
if(U[i]<=0.2*n){
y[i] = rpois(1,lambda1[1])} 
else if(U[i]>0.2*n & U[i]<=0.4*n){
y[i] = rpois(1,lambda1[2])} 
else if(U[i]>0.4*n & U[i]<=0.6*n){
y[i] = rpois(1,lambda1[3])} 
else if(U[i]>0.6*n & U[i]<=0.8*n){
y[i] = rpois(1,lambda1[4])}
else if(U[i]>0.8*n ){
y[i] = rpois(1,lambda1[5])} 
}
M=5
seed=637351
set.seed(123) 
e=sample(c(1:n),K)
alpha0=e/sum(e)
lambda0=c(1.5,2.5,3.5,4.5,5.5)
a=0.75
b=5
M_OEM(y,K,alpha0,lambda0,a,b)
}
