test_that("Replmre2 runs mixed-effects regression across all locations correctly", {
  # Create dummy data
  set.seed(123)
  dummy_data <- data.frame(
    years_education = rnorm(100, 12, 3),
    gender_female = rbinom(100, 1, 0.5),
    household_wealth = sample(1:5, 100, replace = TRUE),
    district_code = sample(1:10, 100, replace = TRUE),
    HHid = as.character(rep(1:20, each = 5, length.out = 100))
  )

  # Define formula
  formula <- years_education ~ gender_female + household_wealth:gender_female

  # Run the mixed-effects model across all locations
  result <- suppressWarnings(Replmre2(dummy_data, formula, "district_code", "HHid"))

  # Test if the result contains the expected columns for estimates and std_error
  expect_true(any(grepl("estimate", colnames(result))))
  expect_true(any(grepl("std_error", colnames(result))))

  # Test if the result contains rows for Marginal and Conditional R-squared
  expect_true(any(grepl("Marginal R-squared", colnames(result))))
  expect_true(any(grepl("Conditional R-squared", colnames(result))))

  # Test if the result has the correct number of rows for all districts
  expect_equal(nrow(result), 10)  # Expect 10 rows for 10 districts
})
