% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_geodata.R
\name{load_geodata}
\alias{load_geodata}
\title{Load Processed Geodata}
\usage{
load_geodata(year)
}
\arguments{
\item{year}{Integer. The year of geodata to load (must be between 1998 and 2022).}
}
\value{
No return value. This function assigns the spatial datasets \code{vg250_lan}, \code{vg250_krs}, and \code{vg250_gem} to the global environment using \code{<<-}.
}
\description{
Loads shapefiles of states (Länder: LAN), districts (Kreise, kreisfreie Städte: KRS), and municipalities (Gemeinde: GEM) for a given year. The shapefiles are processed and assigned to the global environment as \code{vg250_lan}, \code{vg250_krs}, and \code{vg250_gem}. This function is useful if you want to use the shapefiles with other R packages to plot your data.
}
\examples{
\donttest{
# Load the geodata from year 2015 into the R environment
load_geodata(year = 2015)
}
}
