% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/C_make_BLAST_DB.R
\name{make_BLAST_DB}
\alias{make_BLAST_DB}
\title{Make a BLAST Database}
\usage{
make_BLAST_DB(
  fileLoc = NULL,
  makeblastdbPath = "makeblastdb",
  taxaDBLoc = NULL,
  dbName = NULL,
  minLen = 100,
  verbose = TRUE
)
}
\arguments{
\item{fileLoc}{The location of a file in a directory where all fasta files
will be used to construct a BLASTable database (Default NULL).}

\item{makeblastdbPath}{The local path for the blast+ makeblastdbPath program (Default 'makeblastdb').}

\item{taxaDBLoc}{The location of the NCBI taxonomic data base (Default NULL; for accessionTaxa.sql
see the main DBTC page for details).}

\item{dbName}{A short 6-8 alpha character name used when building a database (Default NULL).}

\item{minLen}{The minimum sequence length used to construct the BLAST database (Default 100).}

\item{verbose}{If set to TRUE then there will be output to the R console, if
FALSE then this reporting data is suppressed (Default TRUE).}
}
\value{
The output from this function includes a folder with the BLAST database named
according to the submitted dbName
}
\description{
This function takes a fasta file (in MACER format) and
establishes a database upon which a BLAST search can be completed.
}
\details{
The user inputs the location of a file in a directory that contains a properly formatted
fasta file which can be used to construct a BLASTable database. The
NCBI blast+ program, makeblastdb and the NCBI taxonomic database (accessionTaxa.sql) are required to
run this script (see readme instructions for details).

The examples are present to display the syntax for the function.
These examples are not run because there are files required to run the functions,
in some cases multiple files are necessary and some of these are quite large. To
get specific examples please see https://github.com/rgyoung6/DBTCShinyTutorial/blob/main/README.md
}
\note{
WARNING - NO WHITESPACE!

When running DBTC functions the paths for the files selected cannot have white
space! File folder locations should be as short as possible (close to the root
as some functions do not process long naming conventions.

Also, special characters should be avoided (including question mark, number
sign, exclamation mark). It is recommended that dashes be used for separations
in naming conventions while retaining underscores for use as information
delimiters (this is how DBTC functions use underscore).

There are several key character strings used in the DBTC pipeline, the presence
of these strings in file or folder names will cause errors when running DBTC functions.

The following strings are those used in DBTC and should not be used in file or folder naming:
- _BLAST
- _combinedDada
- _taxaAssign
- _taxaAssignCombined
- _taxaReduced
- _CombineTaxaReduced
}
\examples{
\dontrun{
make_BLAST_DB()
make_BLAST_DB(fileLoc = NULL, makeblastdbPath = "makeblastdb", taxaDBLoc = NULL,
inputFormat = NULL, dbName = NULL, minLen = 100)
}

}
\references{
<https://github.com/rgyoung6/DBTC>
Young, R. G., Hanner, R. H. (Submitted October 2023). Dada-BLAST-Taxon Assign-Condense
Shiny Application (DBTCShiny). Biodiversity Data Journal.
}
\seealso{
dada_implement()
combine_dada_output()
seq_BLAST()
taxon_assign()
combine_assign_output()
reduce_taxa()
combine_reduced_output()
}
\author{
Robert G. Young
}
