% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlation.R
\name{test_correlation_structure}
\alias{test_correlation_structure}
\title{Test for structure of data's correlation matrix}
\usage{
test_correlation_structure(X, structure, method = "BT", repetitions = 1000)
}
\arguments{
\item{X}{a matrix containing the observation vectors as columns (one group)}

\item{structure}{a character specifying the structure regarding them the
correlation matrix should be checked. Options are "Hautoregressive" ("Har"),
"diagonal" ("diag"), "Hcompoundsymmetry" ("Hcs") and "Htoeplitz" ("Hteop").}

\item{method}{a character, to chose whether bootstrap("BT") or Taylor-based
Monte-Carlo-approach("TAY") or Monte-Carlo-technique("MC") is used, while
bootstrap is the predefined method.}

\item{repetitions}{a scalar, indicate the number of runs for the chosen
method.
The predefined value is 1,000, and the number should not be below 500.}
}
\value{
an object of the class \code{\link{CovTest}}
}
\description{
With this function the correlation matrix of data can be checked
for one of the predefined structures. Depending on the chosen method a
bootstrap, the Taylor-based Monte-Carlo approach or  Monte-Carlo-technique
is used to calculate the p-value of the Anova-type-statistic(ATS) based on a
specified number of runs.
}
\examples{
# Load the data
data("EEGwide", package = "MANOVA.RM")

# Select only the males with the diagnosis AD
X <- as.matrix(EEGwide[EEGwide$sex == "W" & EEGwide$diagnosis == "AD",
             c("brainrate_temporal", "brainrate_frontal","brainrate_central",
             "complexity_temporal","complexity_frontal",
             "complexity_central")])

test_correlation_structure(X = X, structure = "diagonal", method = "MC")

}
\references{
Sattler, P. and Dobler, D. (2025). Testing for patterns and structures in covariance and correlation matrices. \emph{arXiv preprint} \url{https://arxiv.org/abs/2310.11799}
}
