% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indecis_indices.R
\name{utci}
\alias{utci}
\title{Universal Thermal Climate Index}
\usage{
utci(
  taverage,
  rh,
  w,
  tmrt,
  data_names = NULL,
  time.scale = YEAR,
  na.rm = FALSE
)
}
\arguments{
\item{taverage}{daily mean temperature, Celsius}

\item{rh}{relative humidity, percentage}

\item{w}{average wind, m/s}

\item{tmrt}{radiation temperature, Celsius}

\item{data_names}{names of each period of time}

\item{time.scale}{month, season or year}

\item{na.rm}{logical. Should missing values (including NaN) be removed?}
}
\value{
index value
}
\description{
The Universal Thermal Climate is defined as the air temperature of the reference condition causing the same model response as actual conditions. The deviation of UTCI from air temperature, depends on the values of air and mean radiant temperature), wind speed and humidity.
}
\examples{
data(data_all)
utci(ta = data_all$tg, rh = data_all$humidity, w = data_all$wind, 
     tmrt = data_all$radiationtemperature)
}
\references{
Blazejczyk, K.; Jendritzky, G.; Bröde, P.; Fiala, D.; Havenith, G.; Epstein, Y., Psikuta, A.; Kampmann, B. 2013. An introduction to the Universal Thermal Climate Index (UTCI). Geographia Polonica, 86 (1), pp.5-10. \url{http://www.utci.org/}
}
