% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indecis_indices.R
\name{stx32}
\alias{stx32}
\title{Sums TX32}
\usage{
stx32(data, data_names = NULL, na.rm = FALSE, ...)
}
\arguments{
\item{data}{daily maximum temperature, Celsius}

\item{data_names}{names of each period of time}

\item{na.rm}{logical. Should missing values (including NaN) be removed?}

\item{...}{further arguments passed to or from other methods}
}
\value{
temperature, Celsius
}
\description{
Sum of degree days when TX >= 32 Celsius on the interval June-August. The 32 celsius limit is the critical biological threshold for the maximum air temperature from which the physiological optimal growth and development of wheat and maize plants.
}
\examples{
data(data_all)
stx32(data = data_all$tx)
}
