% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permute_connected_graphs.r
\name{permute_connected_graphs}
\alias{permute_connected_graphs}
\title{Permute all connected graphs}
\usage{
permute_connected_graphs(n_vertices)
}
\arguments{
\item{n_vertices}{The number of vertices to connect.}
}
\value{
A list of graphs (matrices of dummy labelled edges).
}
\description{
Given a vertex count, permutes all connected graphs.
}
\details{
For the two vertex case there is only a single connected graph:

\preformatted{A---B}

(The labels A and B here simply indicate the two vertices and are not a true labelling.)

If we add a third vertex, there are two connected graphs:

\preformatted{A---B
 \ /
  C}

And:

\preformatted{A---B---C}

This function permutes all such connected graphs for a given vertex count.

Note that the output is in the form of a matrix of edges. For the three vertex case above these would be:

\preformatted{     [,1] [,2]
[1,] "A"  "B"
[2,] "A"  "C"
[3,] "B"  "C"}

And:

\preformatted{     [,1] [,2]
[1,] "A"  "B"
[2,] "B"  "C"}

Again, it is important to note that the labels A, B, and C here are purely "dummy" labels and should not be considered a graph labelling. To use the second graph as an example there are multiple labellings of this graph:

\preformatted{A---B---C}

And:

\preformatted{B---A---C}

And:

\preformatted{A---C---B}

However, these are all isomorphisms of the same unlabelled graph. Only the unique graphs themselves are returned here.
}
\examples{

# Generate all connected graphs of four vertices:
permute_connected_graphs(n_vertices = 4)

}
\author{
Graeme T. Lloyd \email{graemetlloyd@gmail.com}
}
