% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggNlme.R
\name{nlme.cov.splom}
\alias{nlme.cov.splom}
\title{Create covariates scatterplot}
\usage{
nlme.cov.splom(
  xpdb,
  covColNames,
  ggupper = list(continuous = "cor", combo = "box_no_facet", discrete = "count", na =
    "na"),
  gglower = list(continuous = GGally::wrap("smooth", alpha = 0.3, size = 0.1), combo =
    "facethist", discrete = "facetbar", na = "na"),
  ggdiag = list(continuous = "densityDiag", discrete = "barDiag", na = "naDiag"),
  ...
)
}
\arguments{
\item{xpdb}{An xpose database object.}

\item{covColNames}{Character vector of covariates to build the matrix}

\item{ggupper}{See \code{\link[GGally]{ggpairs}()} upper argument.}

\item{gglower}{See \code{\link[GGally]{ggpairs}()} lower argument.}

\item{ggdiag}{See \code{\link[GGally]{ggpairs}()} diag argument.}

\item{...}{Parameters to be passed to \code{\link[GGally]{ggpairs}()}.}
}
\value{
\code{\link[GGally]{ggmatrix}} object.
}
\description{
Use to create covariates scatterplot.
}
\examples{
nlme.cov.splom(xpdb = xpdb_ex_Nlme,
covColNames = c("sex", "wt", "age")
)

}
