% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{add_interaction_terms}
\alias{add_interaction_terms}
\title{Creates interaction terms for specified variables in a data frame
Interaction terms are named as \code{<var1>_int_<var2>} (e.g., \code{Z1_int_Z2} for the product of \code{Z1} and \code{Z2}).}
\usage{
add_interaction_terms(data, Z)
}
\arguments{
\item{data}{Data frame. The data frame containing the variables for which interaction terms are to be created.}

\item{Z}{Character vector. The names of the variables for which interaction terms are to be created.}
}
\value{
A list with two components:
\itemize{
\item \code{data}: The modified data frame with added interaction terms.
\item \code{new_terms}: A character vector of the names of the added interaction terms (e.g., \code{Z1_int_2}).
}
}
\description{
Creates interaction terms for specified variables in a data frame
Interaction terms are named as \code{<var1>_int_<var2>} (e.g., \code{Z1_int_Z2} for the product of \code{Z1} and \code{Z2}).
}
\examples{
data_generator <-  function(N){
Z1 <- rnorm(N,0,1)
Z2 <- rnorm(N,0,1)
X <- rnorm(N, Z1 + Z2, 1)
Y <- rnorm(N, Z1 + Z2, 1)
df <- data.frame(Z1, Z2, X, Y)
return(df)
}
dat <- data_generator(250)
interaction_terms <- add_interaction_terms(data = dat, Z = c("Z1", "Z2"))
head(interaction_terms$data$Z1_int_Z2)

}
