% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{roc_bin}
\alias{roc_bin}
\title{AUC ROC Table for Biomarkers Associated with Binary Outcomes}
\usage{
roc_bin(yvar, xvars, dirs, data, yvar.display = yvar, xvars.display = xvars)
}
\arguments{
\item{yvar}{Binary response variable name, where 0 represents controls and 1 represents cases.}

\item{xvars}{A vector of biomarker names.}

\item{dirs}{A vector of directions for the biomarkers. Options are "auto", ">", or "<".
- "auto" (default): automatically determines in which group the median is higher and takes the direction accordingly.
- ">": indicates that the biomarkers for the control group are higher than those for the case group (controls > t >= cases).
- "<": indicates that the biomarkers for the control group are lower or equal to those for the case group (controls < t <= cases).}

\item{data}{The dataset containing the variables.}

\item{yvar.display}{Display name for the binary response variable.}

\item{xvars.display}{Display names for the biomarkers.}
}
\value{
A table containing the AUC values for each biomarker.
}
\description{
Computes the area under the receiver operating characteristic (ROC) curve for Biomarkers Associated with Binary Outcomes,
and returns the results as a table.
}
\examples{
# Load a sample dataset
data <- data.frame(
  outcome = sample(c(0, 1), 100, replace = TRUE),
  biomarker1 = rnorm(100, mean = 0, sd = 1),
  biomarker2 = rnorm(100, mean = 5, sd = 2)
)

# Compute AUC for a single biomarker with auto direction
roc_bin(
  yvar = "outcome",
  xvars = "biomarker1",
  dirs = "auto",
  data = data,
  yvar.display = "Binary Outcome",
  xvars.display = "Biomarker 1"
)

# Compute AUC for multiple biomarkers with specified directions
roc_bin(
  yvar = "outcome",
  xvars = c("biomarker1", "biomarker2"),
  dirs = c("auto", "<"),
  data = data,
  yvar.display = "Binary Outcome",
  xvars.display = c("Biomarker 1", "Biomarker 2")
)
}
