% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{fixcut_con}
\alias{fixcut_con}
\title{Fixed Cutoff Analysis for Individual Biomarker Associated with Continuous Outcome}
\usage{
fixcut_con(
  yvar,
  xvar,
  dir,
  cutoffs,
  data,
  method = "t.test",
  yvar.display = yvar,
  xvar.display = xvar,
  vert.x = FALSE
)
}
\arguments{
\item{yvar}{Continuous response variable name.}

\item{xvar}{Biomarker name.}

\item{dir}{Cutoff direction for the desired subgroup. Options are ">", ">=", "<", or "<=".}

\item{cutoffs}{A vector of candidate cutoffs.}

\item{data}{The dataset containing the variables.}

\item{method}{Method for cutoff selection. Currently only supports "t.test".
- "t.test": Minimizes the t-test p-value.}

\item{yvar.display}{Display name of the response variable.}

\item{xvar.display}{Display name of the predictor variable.}

\item{vert.x}{Whether to display the cutoff in a 90-degree angle when plotting (saves space).}
}
\value{
A list containing statistical summaries, selected cutoff statistics, selected cutoff value, group statistics,
        and a ggplot object for visualization.
}
\description{
This function conducts fixed cutoff analysis for individual biomarker associated with continuous outcome variables.
}
\examples{
# Load a sample dataset
data <- data.frame(
  outcome = rnorm(100, mean = 10, sd = 5),
  biomarker = rnorm(100, mean = 0, sd = 1)
)

# Perform fixed cutoff analysis using the "t.test" method with '>' direction
fixcut_con(
  yvar = "outcome",
  xvar = "biomarker",
  dir = ">",
  cutoffs = seq(-2, 2, by = 0.5),
  data = data,
  method = "t.test",
  yvar.display = "Continuous Outcome",
  xvar.display = "Biomarker Level",
  vert.x = TRUE
)

# Perform fixed cutoff analysis with '<=' direction
fixcut_con(
  yvar = "outcome",
  xvar = "biomarker",
  dir = "<=",
  cutoffs = c(-1, 0, 1),
  data = data,
  method = "t.test",
  yvar.display = "Continuous Outcome",
  xvar.display = "Biomarker Level",
  vert.x = FALSE
)
}
