% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metric_values.R
\name{metric.values.bugs}
\alias{metric.values.bugs}
\title{Calculate metric values, Bugs}
\usage{
metric.values.bugs(
  myDF,
  MetricNames = NULL,
  boo.Adjust = FALSE,
  cols2keep = NULL,
  MetricSort = NA,
  boo.marine = FALSE,
  boo.Shiny,
  verbose,
  metric_subset,
  taxaid_dni = NULL
)
}
\arguments{
\item{myDF}{Data frame of taxa.}

\item{MetricNames}{Optional vector of metric names to be returned.}

\item{boo.Adjust}{Optional boolean value on whether to perform adjustments of
values prior to scoring.  Default = FALSE but may be TRUE for certain
metrics.}

\item{cols2keep}{Column names of fun.DF to retain in the output.  Uses
column names.}

\item{MetricSort}{How metric names should be sort; NA = as is
, AZ = alphabetical.  Default = NULL.}

\item{boo.marine}{Should estuary/marine metrics be included.
Ignored if fun.MetricNames is not null. Default = FALSE.}

\item{boo.Shiny}{Boolean value for if the function is accessed via Shiny.
Default = FALSE.}

\item{verbose}{Include messages to track progress.  Default = FALSE}

\item{metric_subset}{Subset of metrics to be generated.  Internal function.
Default = NULL}

\item{taxaid_dni}{Taxa names to be included in DNI (Do Not Include) metrics
(n = 3) but dropped for all other metrics.  Only for benthic metrics.
Default = NULL}
}
\value{
Data frame
}
\description{
Subfunction of metric.values for use with Benthic
Macroinvertebrates
}
\details{
For internal use only.  Called from metric.values().
}
\keyword{internal}
