% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preparedata_fn.R
\name{preparedata_fn}
\alias{preparedata_fn}
\title{A function to prepare mortality data with stratification (e.g. by product, sex/gender, country, cause of death etc.)}
\usage{
preparedata_fn(
  data_df_array,
  data_matrix = FALSE,
  strat_name = NULL,
  ages = NULL,
  years = NULL,
  round = TRUE
)
}
\arguments{
\item{data_df_array}{data (normally death counts or exposures) to be provided either as a \strong{data frame} or a \strong{3-dimensional array}. If providing data frame, it should be structured as (column 1: ages, column 2: years, column 3: death/expo data, column 4: strata); if providing array, it should be as (dim 1: strata, dim 2: ages, dim 3: years). \cr
If only one stratum (AP data), either remove column 4 or ensure it contains only one stratum label. Alternatively, one can also provide a \strong{2-dimensional matrix} (age\eqn{\times }year) but please set \code{data_matrix=TRUE}.}

\item{data_matrix}{a logical value indicating if a 2-dimensional matrix (age\eqn{\times }year) is supplied.}

\item{strat_name}{a vector of strings indicating names of each stratum.}

\item{ages}{a numeric vector indicating which ages to use.}

\item{years}{a numeric vector indicating which years to use.}

\item{round}{a logical value indicating whether data entries should be rounded.}
}
\value{
A list with components:
\describe{
\item{\code{data}}{A 3-dimensional data array (dim 1: strata, dim 2: ages, dim 3: years).}
\item{\code{strat_name}}{A vector of strings describing the names of each stratum.}
\item{\code{ages}}{A numeric vector describing the ages used.}
\item{\code{years}}{A numeric vector describing the years used.}
\item{\code{n_strat}}{A numeric value describing the number of strata.}
\item{\code{n_ages}}{A numeric value describing the number of ages.}
\item{\code{n_years}}{A numeric value describing the number of years.}
}
}
\description{
Construct a 3-dimensional data array (dim 1: strata, dim 2: ages, dim 3: years) from raw data frames/arrays suitable for fitting various Bayesian Stochastic Mortality Models.
}
\examples{
##################
##if p>1 (more than 1 strata)
##################

#Input: data.frame
data("data_summarised")
head(data_summarised)

#prepare death data
death<-preparedata_fn(data_summarised[,c("Age","Year","Claim","Product")],
strat_name = c("ACI","DB","SCI"),ages=35:65)
#prepare exposure data
expo<-preparedata_fn(data_summarised[,c("Age","Year","Exposure","Product")],
strat_name = c("ACI","DB","SCI"),ages=35:65)

#visualise data
str(death);str(expo)

#works also if data.frame only contains only 1 stratum
death<-preparedata_fn(data_summarised[,
c("Age","Year","Claim","Product")][data_summarised$Product=="ACI",],ages=35:65)

expo<-preparedata_fn(data_summarised[,
c("Age","Year","Exposure","Product")][data_summarised$Product=="ACI",],ages=35:65)

str(death);str(expo)

#Input: 3D data array
data("dxt_array_product");data("Ext_array_product")
death<-preparedata_fn(dxt_array_product,ages=35:65)
expo<-preparedata_fn(Ext_array_product,ages=35:65)

str(death);str(expo)

##################
##if p=1 (only 1 stratum)
##################

#specifying only one of the strats from the data.frame
death<-preparedata_fn(data_summarised[,c("Age","Year","Claim","Product")],
  strat_name = "ACI",ages=35:65)
expo<-preparedata_fn(data_summarised[,c("Age","Year","Exposure","Product")],
  strat_name = "ACI",ages=35:65)
str(death);str(expo)

#if data.frame only contains 1 strat (4 columns)
death<-preparedata_fn(data_summarised[,c("Age","Year","Claim","Product")]
  [data_summarised$Product=="ACI",],ages=35:65)
expo<-preparedata_fn(data_summarised[,c("Age","Year","Exposure","Product")]
  [data_summarised$Product=="ACI",],ages=35:65)
str(death);str(expo)

#if data.frame only contains 1 strat (3 columns)
death<-preparedata_fn(data_summarised[,c("Age","Year","Claim")]
  [data_summarised$Product=="ACI",],ages=35:65)
expo<-preparedata_fn(data_summarised[,c("Age","Year","Exposure")]
  [data_summarised$Product=="ACI",],ages=35:65)
str(death);str(expo)

#Input: 3D data array
death<-preparedata_fn(dxt_array_product,strat_name="ACI",ages=35:65)
expo<-preparedata_fn(Ext_array_product,strat_name="ACI",ages=35:65)
str(death);str(expo)

#Input: 2D matrix 
death<-preparedata_fn(dxt_array_product["ACI",,],data_matrix=TRUE,ages=35:65)
expo<-preparedata_fn(Ext_array_product["ACI",,],data_matrix=TRUE,ages=35:65)
str(death);str(expo)
}
\concept{data formatting}
\concept{data preprocessing}
\concept{mortality data}
\concept{stratification}
\keyword{utilities}
