% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/converge_diag_rates_fn.R
\name{converge_diag_rates_fn}
\alias{converge_diag_rates_fn}
\title{A function to assess convergence of the posterior sampling of death rates for monitoring purposes}
\usage{
converge_diag_rates_fn(
  result,
  plot_ages = NULL,
  plot_years = NULL,
  plot_strata = NULL,
  trace = TRUE,
  density = TRUE,
  acf_plot = FALSE,
  ESS_all = FALSE
)
}
\arguments{
\item{result}{object of type either "fit_result" or "BayesMoFo".}

\item{plot_ages}{A numeric vector specifying which range of ages to plot for visualisation. If not specified, a random selection of ages that were used to fit the model (i.e. \code{fit_result$death$ages}) will be chosen.}

\item{plot_years}{A numeric vector specifying which range of years to plot for visualisation. If not specified, a random selection of years that were used to fit the model (i.e. \code{fit_result$death$years}) will be chosen.}

\item{plot_strata}{A vector of character strings specifying which strata to plot for visualisation. If not specified, a random selection of the strata used to fit the model (i.e. \code{fit_result$death$strat_name}) will be chosen.}

\item{trace}{A logical value to indicate if trace plots of posterior samples of death rates should be shown (default) or suppressed (e.g. to aid visibility).}

\item{density}{A logical value to indicate if density plots of posterior samples of death rates should be shown (default) or suppressed (e.g. to aid visibility).}

\item{acf_plot}{A logical value to indicate if auto-correlation plots should be shown or suppressed (default).}

\item{ESS_all}{A logical value indicating if effective sample sizes are to be computed for all rates. The default is FALSE where only chosen rates will be evaluated, if TRUE all rates will be assessed.}
}
\value{
Some convergence-related plots of posterior samples of mortality rates.
\describe{
\item{\code{ESS}}{The effective sample sizes of the chosen parameters.}
}
}
\description{
Produce several convergence diagnostic tools (e.g. trace/density/acf plots and effective sample sizes) from the posterior samples of death rates.
}
\examples{
\donttest{
#load and prepare data
data("dxt_array_product");data("Ext_array_product")
death<-preparedata_fn(dxt_array_product,strat_name = c("ACI","DB","SCI"),ages=35:65)
expo<-preparedata_fn(Ext_array_product,strat_name = c("ACI","DB","SCI"),ages=35:65)

#fit any mortality model
runBayesMoFo_result<-runBayesMoFo(death=death,expo=expo,models="APCI")

#default plot
converge_runBayesMoFo_result<-converge_diag_rates_fn(runBayesMoFo_result)

#ESS
converge_runBayesMoFo_result$ESS

#plot by age and changing pre-specified arguments 
converge_diag_rates_fn(runBayesMoFo_result,plot_ages=c(40,50,60),plot_years=c(2017,2020))

#ACF plot 
converge_diag_rates_fn(runBayesMoFo_result,plot_ages=c(40,50,60),plot_years=c(2017,2020),
trace=FALSE,density=FALSE,acf_plot=TRUE)
}
}
\concept{autocorrelations}
\concept{death rates}
\concept{density plots}
\concept{effective sample sizes}
\concept{posterior samples}
\concept{trace plots}
\keyword{bayesian}
\keyword{diagnostics}
\keyword{visualization}
