% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz_murakami_dist.r
\name{murakami_cdf}
\alias{murakami_cdf}
\title{Murakami test statistic distribution.}
\usage{
murakami_cdf(B, n1, n2, flavor = 0L, lower_tail = TRUE)
}
\arguments{
\item{B}{the Murakami test statistic or a vector of the same.}

\item{n1}{number of elements in the first sample.}

\item{n2}{number of elements in the second sample.}

\item{flavor}{the 'flavor' of the test statistic. See
\code{\link{murakami_stat}}.}

\item{lower_tail}{boolean, when \code{TRUE} returns the CDF, \eqn{\Psi}{Psi}, otherwise 
compute the upper tail, \eqn{1-\Psi}{1 - Psi}, which is potentially more useful for hypothesis tests.}
}
\value{
a vector of the same size as \code{B} of the CDF under the null.
}
\description{
Estimates the CDF of the Murakami test statistics via permutations.
}
\details{
Given the Murakami test statistic \eqn{B_j} for \eqn{0 \le j \le 5}{0 <= j <= 5},
computes the CDF under the null that the two samples come from the same
distribution. The CDF is computed by permutation test and memoization.
}
\note{
the CDF is approximately computed by evaluating the permutations up to
some reasonably small sample size (currently the cutoff is 9). When larger
sample sizes are used, the distribution of the test statistic may not
converge. This is apparently seen in flavors 3 through 5.
}
\examples{

# basic usage:
xv <- seq(0,4,length.out=101)
yv <- murakami_cdf(xv, n1=8, n2=6, flavor=1L)
plot(xv,yv)
zv <- bws_cdf(xv)
lines(xv,zv,col='red')

# check under the null:
\donttest{
flavor <- 1L
n1 <- 8
n2 <- 8
set.seed(1234)
Bvals <- replicate(2000,murakami_stat(rnorm(n1),rnorm(n2),flavor))
# should be uniform:
plot(ecdf(murakami_cdf(Bvals,n1,n2,flavor)))
}

}
\references{
W. Baumgartner, P. Weiss, H. Schindler, 'A nonparametric test for the general two-sample problem', 
Biometrics 54, no. 3 (Sep., 1998): pp. 1129-1135. 
\doi{10.2307/2533862}

M. Neuhauser, 'Exact tests based on the Baumgartner-Weiss-Schindler Statistic--a survey', 
Statistical Papers 46, no. 1 (2005): pp. 1-30.
\doi{10.1007/BF02762032}

M. Neuhauser, 'One-sided two-sample and trend tests based on a modified 
Baumgartner-Weiss-Schindler statistic', J. Nonparametric Statistics 13, no.
5 (2001): pp 729-739.
\doi{10.1080/10485250108832874}

H. Murakami, 'K-sample rank test based on modified Baumgartner statistic and
its power comparison', J. Jpn. Comp. Statist. 19, no. 1 (2006): pp. 1-13.
\doi{10.5183/jjscs1988.19.1}

H. Murakami, 'Modified Baumgartner Statistics for the two-sample and
multisample problems: a numerical comparison', J. Stat. Comp. and Sim.
82, no. 5 (2012): pp. 711-728.
\doi{10.1080/00949655.2010.551516}

H. Murakami, 'Lepage type statistic based on the modified Baumgartner statistic',
Comp. Stat. & Data Analysis 51 (2007): pp 5061-5067. 
\doi{10.1016/j.csda.2006.04.026}
}
\seealso{
\code{\link{murakami_stat}}.
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
