% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pred_prob.R
\name{predicted_probability}
\alias{predicted_probability}
\title{Predicted Probabilities}
\usage{
predicted_probability(object, outcome, Y, ...)
}
\arguments{
\item{object}{An object of class \code{posterior_predict}}

\item{outcome}{Character string. Node for which the probabilities are computed.}

\item{Y}{Matrix (or data frame) of dimensions \emph{n} (observations) by  \emph{p} (variables).
This must include the column names.}

\item{...}{Compute conditional probabilities by specifying a column name in \code{Y}
(besides the \code{outcome}) and a fixed value. This can include
any number of nodes. See example below. Leave this blank to compute
unconditional probabilities for \code{outcome}.}
}
\value{
A list containing a matrix with the computed probabilities
       (a row for each predictive sample and a column for each category).
}
\description{
Compute the predicted probabilities for discrete data, with the possibility
of conditional predictive probabilities (i.e., at fixed values of other nodes)
}
\note{
There are no checks that the conditional probability exists, i.e., suppose
      you wish to condition on, say, B3 = 2 and B4 = 1, yet there is no instance in
      which B3 is 2 AND B4 is 1. This will result in an uninformative error.
}
\examples{
\donttest{
Y <- ptsd
fit <- estimate(as.matrix(Y), iter = 150, type = "mixed")

pred <- posterior_predict(fit, iter = 100)

prob <- predicted_probability(pred,
                              Y = Y,
                              outcome = "B3",
                              B4 = 0,
                              B5 = 0)

}
}
