% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_acwr.R
\name{calculate_acwr}
\alias{calculate_acwr}
\title{Calculate ACWR Data}
\usage{
calculate_acwr(
  stoken,
  activity_type = NULL,
  load_metric = "duration_mins",
  acute_period = 7,
  chronic_period = 28,
  start_date = NULL,
  end_date = NULL,
  user_ftp = NULL,
  user_max_hr = NULL,
  user_resting_hr = NULL,
  smoothing_period = 7
)
}
\arguments{
\item{stoken}{A valid Strava token from `rStrava::strava_oauth()`.}

\item{activity_type}{Optional. Filter activities by type (e.g., "Run", "Ride").
Default `NULL` includes all types.}

\item{load_metric}{Method for calculating daily load (e.g., "duration_mins",
"distance_km", "tss", "hrss"). Default "duration_mins".}

\item{acute_period}{Days for the acute load window (e.g., 7).}

\item{chronic_period}{Days for the chronic load window (e.g., 28). Must be greater than `acute_period`.}

\item{start_date}{Optional. Analysis start date (YYYY-MM-DD string or Date). Defaults to one year ago.}

\item{end_date}{Optional. Analysis end date (YYYY-MM-DD string or Date). Defaults to today.}

\item{user_ftp}{Required if `load_metric = "tss"`. Your Functional Threshold Power.}

\item{user_max_hr}{Required if `load_metric = "hrss"`. Your maximum heart rate.}

\item{user_resting_hr}{Required if `load_metric = "hrss"`. Your resting heart rate.}

\item{smoothing_period}{Days for smoothing the ACWR using a rolling mean (e.g., 7). Default 7.}
}
\value{
A data frame with columns: `date`, `atl` (Acute Load), `ctl` (Chronic Load),
`acwr` (raw ACWR), and `acwr_smooth` (smoothed ACWR) for the specified date range.
}
\description{
Calculates the Acute:Chronic Workload Ratio (ACWR) from Strava data.
}
\details{
Calculates daily load, ATL, CTL, raw ACWR, and smoothed ACWR from Strava activities.

Provides data for `plot_acwr`. Fetches extra prior data for accurate
  initial CTL. Fetching can be slow for long periods.
}
\examples{
# Example using simulated data (Note: sample data is pre-calculated, shown for demonstration)
data(Athlytics_sample_data)
if (!is.null(athlytics_sample_acwr)) {
  print(head(athlytics_sample_acwr))
}

\dontrun{
# Example using real data (requires authentication and app setup)
# Replace with your actual app_name, client_id, and secret or ensure stoken is pre-configured
# stoken <- rStrava::strava_oauth(
#   app_name = "YOUR_APP_NAME",
#   client_id = "YOUR_CLIENT_ID",
#   client_secret = "YOUR_SECRET",
#   cache = TRUE 
# )
# if (interactive() && exists("stoken")) { # Proceed if stoken is available
#   # Calculate ACWR for Runs (using duration)
#   run_acwr <- calculate_acwr(stoken = stoken, activity_type = "Run",
#                              load_metric = "duration_mins")
#   print(tail(run_acwr))
#
#   # Calculate ACWR for Rides (using TSS, requires FTP)
#   ride_acwr_tss <- calculate_acwr(stoken = stoken, activity_type = "Ride",
#                                   load_metric = "tss", user_ftp = 280)
#   print(tail(ride_acwr_tss))
# } else {
#   message("Strava token not available or not in interactive session, skipping real data example.")
# }
}
}
