% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Af_compare_methods.R
\name{Af_compare_methods}
\alias{Af_compare_methods}
\title{Function to compare trees created with different algorithms from the same clonotype.}
\usage{
Af_compare_methods(
  input,
  min.nodes,
  include.average,
  distance.method,
  depth,
  clustering.method,
  visualization.methods,
  parallel,
  num.cores
)
}
\arguments{
\item{input}{A list of AntibodyForests-objects as output from the function Af_build(). These objects should contain the same samples/clonotypes. For easy interpretation of the results, please name the objects in the list according to their tree-construction method.}

\item{min.nodes}{The minimum number of nodes in a tree to include in the comparison, this includes the germline. Default is 2 (this includes all trees).}

\item{include.average}{If TRUE, the average distance matrix and visualizations between the trees is included in the output (default FALSE)}

\item{distance.method}{The method to calculate the distance between trees (default euclidean)
'euclidean'      : Euclidean distance between the depth of each node in the tree
'GBLD'           : Generalized Branch Length Distance, derived from Mahsa Farnia & Nadia Tahiri, Algorithms Mol Biol 19, 22 (2024). https://doi.org/10.1186/s13015-024-00267-1}

\item{depth}{If distance.methods is 'euclidean', method to calculate the germline-to-node depth (default edge.count)
'edge.count'   : The number of edges between each node and the germline
'edge.length'  : The sum of edge lengths between each node and the germline}

\item{clustering.method}{Method to cluster trees (default NULL)
NULL             : No clustering
'mediods'        : Clustering based on the k-mediods method. The number of clusters is estimated based on the optimum average silhouette.}

\item{visualization.methods}{The methods to analyze similarity (default NULL)
NULL             : No visualization
'PCA'            : Scatterplot of the first two principal components.
'MDS'            : Scatterplot of the first two dimensions using multidimensional scaling.
"heatmap'        : Heatmap of the distance}

\item{parallel}{If TRUE, the depth calculations are parallelized across clonotypes (default FALSE)}

\item{num.cores}{Number of cores to be used when parallel = TRUE. (Defaults to all available cores - 1)}
}
\value{
A list with all clonotypes that pass the min.nodes threshold including the distance matrix, possible clustering and visualization
}
\description{
Function to compare different trees from the same clonotype to compare various graph construction and phylogenetic reconstruction methods.
}
\examples{
plot <- Af_compare_methods(input = list("Default" = AntibodyForests::af_default,
                                        "MST" = AntibodyForests::af_mst,
                                        "NJ" = AntibodyForests::af_nj),
                           depth = "edge.count",
                           visualization.methods = "heatmap",
                           include.average = TRUE)
plot$average
}
