% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Distance_matrix_knn_algorithm.R
\name{distance_matrix_cort}
\alias{distance_matrix_cort}
\title{Distance matrix from a pattern recognition distance}
\usage{
distance_matrix_cort(k, unit)
}
\arguments{
\item{k}{The parameter $k$ controls the contribution of the sum of squares
comparison as a value-based metric and the $Cort$ quantity as a behavioral
metric; when $k=0$, then the distance is equal to the value-based metric,
on the other hand, when $k=6$ the distance is mainly determined by the value
of the temporal correlation $Cort$.}

\item{unit}{A matrix representing a multivariate time series where each
column is a univariate time series.}
}
\value{
a matrix with pairwise distances
}
\description{
pairwise distance matrix of a multivariate time series based on a value
(Euclidean distance) and behavior (temporal correlation) measures
}
\examples{
X=matrix( rnorm(200), ncol=10  )
k=2
distance_matrix_cort(k,X)
}
\seealso{
Douzal-Chouakria, Ahlame, and Cecile Amblard. "Classification
Trees for Time Series." Pattern Recognition 45, no. 3 (March 2012):
1076-91. \doi{10.1016/j.patcog.2011.08.018}
}
