% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Motif2TF_functions.R
\name{Maelstrom_Motif2TF}
\alias{Maelstrom_Motif2TF}
\title{Maelstrom_Motif2TF}
\usage{
Maelstrom_Motif2TF(
  seurat_object,
  mot_mat = NULL,
  m2f_df = NULL,
  cluster_id = "seurat_clusters",
  maelstrom_dir = "./maelstrom/",
  combine_motifs = "means",
  RNA_expression_assay = "RNA",
  RNA_expression_slot = "data",
  expr_tresh = 10,
  cor_tresh = 0.3,
  curated_motifs = FALSE,
  cor_method = "pearson",
  return_df = FALSE
)
}
\arguments{
\item{seurat_object}{object}

\item{mot_mat}{motif_matrix, if not provided extracts one from the single cell object from the maelstrom assay}

\item{m2f_df}{motif to factor dataframe, if not provided extracts from the maelstrom directory}

\item{cluster_id}{ID used for finding clusters of cells}

\item{maelstrom_dir}{directory where the GimmeMotifs m2f table is stored}

\item{combine_motifs}{means (take mean multiple motifscores), max_var (take motif with highest variance), or max_cor (take motif with best correlation to gene expression)}

\item{RNA_expression_assay}{Seurat assay containing factor expression info}

\item{RNA_expression_slot}{slot within assay used for calculating mean factor expression per cluster}

\item{expr_tresh}{minimum sum of gene counts over all cells in RNA_expression_assay to filter genes by}

\item{cor_tresh}{minimum value of to filter the cor() output by}

\item{curated_motifs}{use only curated motifs (T), or all motifs in the database (F)}

\item{cor_method}{specify one of the cor() methods}

\item{return_df}{return both the seurat object and two dataframes with maelstrom scores and expression values as a list}
}
\value{
seurat object with two assays added, MotifTFcor for TFs with positive correlation to the linked motif, and MotifTFanticor for TFs with positive correlation to the linked motif
}
\description{
create motif-factor links & export tables for printing motif score alongside its binding factor
}
\examples{
sce_small <- readRDS(system.file("extdata","sce_small.Rds",package = 'AnanseSeurat'))
maelstrom_dir_path <- system.file("extdata","maelstrom",package = 'AnanseSeurat')
sce_small <- Maelstrom_Motif2TF(sce_small, maelstrom_dir = maelstrom_dir_path)
}
