% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/250605_axQnt_v0.99.6.R
\name{axQnt}
\alias{axQnt}
\title{Quantify Axon Integrity and Degeneration Indices from Images or Feature Data}
\usage{
axQnt(
  imprtImg = TRUE,
  subBack = 30,
  resizeW = 900,
  binaryImg = FALSE,
  expSip = TRUE,
  svm_model_path = tempdir(),
  input_dirs = NULL,
  output_dir = tempdir()
)
}
\arguments{
\item{imprtImg}{Logical. If TRUE, imports and processes image files (.tiff). If FALSE, uses precomputed feature data (.txt). (default: TRUE)}

\item{subBack}{Numeric. Area threshold in pixels: connected components (objects) with area less than or equal to this value will be removed as background. (default: 30)}

\item{resizeW}{Numeric. Target width in pixels for resizing each imported image (default: 900). Larger values may improve analysis accuracy up to a point, but also increase memory and computation time. Excessively large values may not further improve results.}

\item{binaryImg}{Logical. If TRUE, exports binary image files. (default: FALSE)}

\item{expSip}{Logical. If TRUE, exports single image prediction results as .csv files. (default: TRUE)}

\item{svm_model_path}{Character. Path to a pre-trained SVM model file (.RData or .svm). If NULL, a file selection dialog will be shown. (default: NULL)}

\item{input_dirs}{Character. Path to the folders containing input files (.tiff or .txt). If NULL, a folder selection dialog will be shown. (default: NULL)}

\item{output_dir}{Character. Path to the output directory. If NULL, a folder selection dialog will be shown; if empty, current working directory is used. (default: NULL)}
}
\value{
The function does not return values directly but generates the following outputs:
\itemize{
\item A summary .csv file containing the calculated Axon Integrity Index (AII) and Degeneration Index (DI) for each file.
\item (Optional) Single image prediction results as .csv files if \code{expSip = TRUE}.
\item (Optional) Processed image data as .txt files if \code{imprtImg = TRUE}.
}
}
\description{
\code{axQnt} calculates the Axon Integrity Index (AII) and Degeneration Index (DI) from axon image files (.tiff) or precomputed feature data (.txt).
The function uses a pre-trained SVM model to classify axonal regions and computes indices based on classified areas.
\code{axQnt} supports both interactive GUI-based file/folder selection and direct path specification for input and output, with cross-platform compatibility.
}
\details{
The function implements a complete quantification pipeline:
\enumerate{
\item \strong{Model loading}: Loads a pre-trained SVM model from the specified file or via GUI selection. Automatically detects SVM objects within the loaded file.
\item \strong{Input handling}: If input paths are not specified, the user is prompted to select folders via a GUI dialog (cross-platform support for RStudio, tcltk, svDialogs, or manual input).
\item \strong{Data preprocessing}: Depending on \code{imprtImg}, either processes image files (.tiff) to extract features utilizing the same pipeline as \code{\link{axDistmap}} or directly utilizes precomputed feature data (.txt).
\item \strong{SVM classification}: Utilizes the loaded SVM model to classify axonal regions into "Degenerate" or "Intact" based on morphological features.
\item \strong{Index calculation}: Calculates Axon Integrity Index (AII) and Degeneration Index (DI) based on classified areas:
\deqn{AII = \frac{\text{Area of Intact Axons}}{\text{Total Axonal Area}}}
\deqn{DI = \frac{\text{Area of Degenerate Axons}}{\text{Total Axonal Area}}}
\item \strong{Result saving}: Exports summary and optional detailed prediction files with unique filenames to prevent overwriting.
}
}
\note{
\itemize{
\item The function requires a pre-trained SVM model compatible with the feature set used by \code{\link{axDistmap}} and \code{\link{axSvm}}.
\item Required features for SVM classification: m.eccentricity, s.radius.sd, h.sva.s2, h.idm.s1, h.sen.s1, m.majoraxis.
\item When \code{imprtImg = TRUE}, images are processed using the same pipeline as \code{\link{axDistmap}} with the specified \code{resizeW} and \code{subBack} parameters.
\item Single image prediction results are exported only if \code{expSip = TRUE}.
\item Compatible with feature data and models from \code{\link{axDistmap}} and \code{\link{axSvm}}.
\item Output files include timestamp in ISO 8601 format (YYYY-MM-DD).
}
}
\section{File Naming and Overwrite Policy}{

\itemize{
\item Output files are automatically named with timestamps in ISO 8601 format (YYYY-MM-DD).
\item If a file name already exists, a unique name with a numeric suffix is generated to avoid overwriting.
\item If the output directory does not exist, it will be created automatically.
}
}

\section{GUI Support}{

\itemize{
\item RStudio (rstudioapi), tcltk, and svDialogs are supported for file/folder selection.
\item If no GUI is available, the user is prompted to enter the path manually.
\item Cross-platform compatibility for Windows, macOS, and Linux.
}
}

\examples{
# Interactive mode: process .tiff images with GUI dialogs
# NOTE: This example requires a GUI environment for interactive folder selection.
if (interactive()){
axQnt(imprtImg = TRUE, expSip = TRUE)
}

# Utilize package-included image folder and output to temporary directory
\donttest{
img_dir <- system.file("extdata", "Degenerate_Images", package = "AiES")
svm_model <- system.file("extdata", "svm_example_model.svm", package = "AiES")
axQnt(imprtImg = TRUE, svm_model_path = svm_model, input_dirs = img_dir, output_dir = tempdir())

# Process with custom image resize and background threshold
img_dir <- system.file("extdata", "Intact_Images", package = "AiES")
svm_model <- system.file("extdata", "svm_example_model.svm", package = "AiES")
axQnt(imprtImg = TRUE, resizeW = 700, subBack = 50,
svm_model_path = svm_model, input_dirs = img_dir, output_dir = tempdir())
}

# Utilize package-included precomputed feature data from .txt files
# and output to temporary directory
txt_dir <- system.file("extdata", "Degenerate_txt", package = "AiES")
svm_model <- system.file("extdata", "svm_example_model.svm", package = "AiES")
axQnt(imprtImg = FALSE, svm_model_path = svm_model, input_dirs = txt_dir, output_dir = tempdir())


}
