% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R
\name{calc_adlp_component}
\alias{calc_adlp_component}
\alias{calc_adlp_component_lst}
\title{Accident and Development period Adjusted Linear Pools Component Models}
\usage{
calc_adlp_component(
  component,
  newdata,
  y = NULL,
  model = c("train", "full"),
  calc = c("pdf", "cdf", "mu", "sim")
)

calc_adlp_component_lst(
  components_lst,
  newdata,
  model = c("train", "full"),
  calc = c("pdf", "cdf", "mu", "sim"),
  ...
)
}
\arguments{
\item{component}{Object of class \code{adlp_component}}

\item{newdata}{Claims Triangle and other information. \code{data.frame} format of
claims and related information for each cell. Dataframe will have columns
\code{origin} and \code{dev} as columns 1 and 2 respectively.}

\item{y}{Optional vector of \code{y} to be used in pdf or cdf calculations. Will
default to the response fetched by \code{model.frame}.}

\item{model}{Whether the training component model or the full component model
should be used}

\item{calc}{Type of calculation to perform}

\item{components_lst}{List of objects of class \code{adlp_component}}

\item{...}{Other parameters to be passed into \code{calc_adlp_component}}
}
\value{
The result of the evaluated function on the \code{adlp_component}. This
would be a vector with the same length as rows on \code{newdata} with the
calculations.
}
\description{
Accident and Development period Adjusted Linear Pools Component Models
}
\details{
Calls the specified function for an object of class \code{adlp_component}.

\code{calc_adlp_component_lst} is a wrapper for \code{calc_adlp_component} for each
component in the list \code{components_lst}. This wrapper also contains functionality
to signal the component that causes an error if it is occuring downstream.
}
\examples{
data(test_adlp_component)

newdata <-  test_adlp_component$model_train$data
pdf_data = calc_adlp_component(test_adlp_component, newdata = newdata,
                          model = "train", calc = "pdf")

data(test_adlp_component)
test_component1 <- test_adlp_component
test_component2 <- test_adlp_component
test_components <- adlp_components(
    component1 = test_component1,
    component2 = test_component2
)

newdata <-  test_adlp_component$model_train$data
pdf_data = calc_adlp_component_lst(test_components, newdata = newdata,
                          model = "train", calc = "pdf")
}
