% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores_nc.R
\docType{data}
\name{vars_nc_y_ehis}
\alias{vars_nc_y_ehis}
\alias{compute_nc_y_ehis_score}
\title{Compute "Edinburgh Handedness Inventory [Youth] (Handedness score rating)"}
\format{
vars_nc_y_ehis is a character vector of all column names
used to compute summary scores of \code{nc_y_ehis}.
}
\usage{
vars_nc_y_ehis

compute_nc_y_ehis_score(
  data,
  name = "nc_y_ehis_score",
  max_na = 0,
  combine = TRUE
)
}
\arguments{
\item{data}{tbl, Dataframe containing the columns to be summarized.}

\item{name}{character, Name of the new column to be created. Default is
the name in description, but users can change it.}

\item{max_na}{integer, Maximum number of missing values allowed in the
summary score. \code{NULL} means no limit.}

\item{combine}{logical, If \code{TRUE}, the summary score will be appended to
the input data frame. If \code{FALSE}, the summary score will be returned as a
separate data frame.}
}
\value{
tbl. The input data frame with the summary score appended as
a new column.
}
\description{
Computes the summary score \code{nc_y_ehis_score}
Edinburgh Handedness Inventory [Youth] (Handedness score rating)
\itemize{
\item \emph{Summarized variables:}
\itemize{
\item \code{nc_y_ehis_001}
\item \code{nc_y_ehis_002}
\item \code{nc_y_ehis_003}
\item \code{nc_y_ehis_004}
}
}
}
\examples{
\dontrun{
compute_nc_y_ehis_score(data) |>
  select(
    data,
    all_of(c("nc_y_ehis_score", vars_nc_y_ehis))
  )
}
}
\keyword{datasets}
