/*
 * Decompiled with CFR 0.152.
 */
package mrmc.chart;

import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import mrmc.chart.InterpolatedLine;
import mrmc.chart.WrapLayout;
import mrmc.chart.XYPair;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class ROCCurvePlot
extends JFrame {
    private static final long serialVersionUID = 1L;
    private XYLineAndShapeRenderer renderer;
    public XYSeriesCollection seriesCollection;
    private ArrayList<InterpolatedLine> allLines;
    private ArrayList<String> readerSeriesTitles;
    private ArrayList<JCheckBox> readerSeriesBoxes;
    private JCheckBox vert;
    private JCheckBox horiz;
    private JCheckBox diag;
    private JCheckBox pooled;
    private String inputfilepathandname;
    private String filename;
    private Set<String> modalityID;

    public ROCCurvePlot(String title, String xaxis, String yaxis, TreeMap<String, TreeMap<String, TreeSet<XYPair>>> fulltreeMap, String filePathAndName, String fileName) {
        super(title);
        this.inputfilepathandname = filePathAndName;
        this.filename = fileName.substring(0, fileName.lastIndexOf("."));
        TextTitle subtitle = new TextTitle(fileName);
        this.seriesCollection = new XYSeriesCollection();
        this.readerSeriesTitles = new ArrayList();
        this.modalityID = fulltreeMap.keySet();
        ArrayList<String> readerarray = new ArrayList<String>();
        for (String mod : this.modalityID) {
            TreeMap<String, TreeSet<XYPair>> treeMap = fulltreeMap.get(mod);
            this.createDataset(mod, treeMap);
            for (String r : treeMap.keySet()) {
                if (readerarray.contains(r)) continue;
                readerarray.add(r);
            }
        }
        Collections.sort(readerarray.subList(0, readerarray.size()));
        JFreeChart chart = ChartFactory.createScatterPlot(title, xaxis, yaxis, this.seriesCollection, PlotOrientation.VERTICAL, true, true, false);
        chart.addSubtitle(subtitle);
        XYPlot xyplot = (XYPlot)chart.getPlot();
        xyplot.setDomainCrosshairVisible(true);
        xyplot.setRangeCrosshairVisible(true);
        NumberAxis domain = (NumberAxis)xyplot.getDomainAxis();
        domain.setRange(0.0, 1.0);
        domain.setTickUnit(new NumberTickUnit(0.1));
        NumberAxis range = (NumberAxis)xyplot.getRangeAxis();
        range.setRange(0.0, 1.0);
        range.setTickUnit(new NumberTickUnit(0.1));
        this.renderer = new XYLineAndShapeRenderer();
        chart.getXYPlot().setRenderer(this.renderer);
        ChartPanel chartPanel = new ChartPanel(chart);
        JPanel readerSelect = new JPanel(new WrapLayout());
        this.readerSeriesBoxes = new ArrayList();
        for (String r : readerarray) {
            JCheckBox aBox = new JCheckBox(r);
            aBox.setSelected(false);
            aBox.addItemListener(new SeriesSelectListener());
            this.hideSeries(r);
            this.readerSeriesBoxes.add(aBox);
            readerSelect.add(aBox);
        }
        this.hideSeries("Vertical Average");
        this.hideSeries("Horizontal Average");
        this.hideSeries("Pooled Average");
        this.hideSeries("Diagonal Average");
        this.showSeries("Diagonal Average", false);
        for (String mod : this.modalityID) {
            this.renderer.setSeriesStroke(this.seriesCollection.getSeriesIndex((Comparable)((Object)(String.valueOf(mod) + ": Vertical Average"))), new BasicStroke(3.0f));
            this.renderer.setSeriesStroke(this.seriesCollection.getSeriesIndex((Comparable)((Object)(String.valueOf(mod) + ": Horizontal Average"))), new BasicStroke(3.0f));
            this.renderer.setSeriesStroke(this.seriesCollection.getSeriesIndex((Comparable)((Object)(String.valueOf(mod) + ": Diagonal Average"))), new BasicStroke(3.0f));
            this.renderer.setSeriesStroke(this.seriesCollection.getSeriesIndex((Comparable)((Object)(String.valueOf(mod) + ": Pooled Average"))), new BasicStroke(3.0f));
        }
        this.vert = new JCheckBox("Vertical Average");
        this.vert.setSelected(false);
        this.vert.addItemListener(new SeriesSelectListener());
        readerSelect.add(this.vert);
        this.horiz = new JCheckBox("Horizontal Average");
        this.horiz.setSelected(false);
        this.horiz.addItemListener(new SeriesSelectListener());
        readerSelect.add(this.horiz);
        this.diag = new JCheckBox("Diagonal Average");
        this.diag.setSelected(true);
        this.diag.addItemListener(new SeriesSelectListener());
        readerSelect.add(this.diag);
        this.pooled = new JCheckBox("Pooled Average");
        this.pooled.setSelected(false);
        this.pooled.addItemListener(new SeriesSelectListener());
        readerSelect.add(this.pooled);
        JCheckBox allReaders = new JCheckBox("Show Readers");
        allReaders.setSelected(false);
        allReaders.addItemListener(new ReadersSelectListener());
        readerSelect.add(allReaders);
        JCheckBox allAverages = new JCheckBox("Show Averages");
        allAverages.setSelected(false);
        allAverages.addItemListener(new AverageSelectListener());
        readerSelect.add(allAverages);
        JButton exportresult = new JButton("Export");
        exportresult.addActionListener(new exportROCresult());
        readerSelect.add(exportresult);
        chartPanel.setPreferredSize(new Dimension(700, 700));
        this.add(chartPanel);
        this.add((Component)readerSelect, "Last");
    }

    private void createDataset(String mod, TreeMap<String, TreeSet<XYPair>> treeMap) {
        for (String r : treeMap.keySet()) {
            XYSeries series = new XYSeries((Comparable)((Object)(String.valueOf(mod) + ": " + r)), false);
            this.readerSeriesTitles.add(r);
            for (XYPair point : treeMap.get(r)) {
                series.add(point.x, point.y);
            }
            this.seriesCollection.addSeries(series);
        }
        this.allLines = new ArrayList();
        for (String r : treeMap.keySet()) {
            this.allLines.add(new InterpolatedLine(treeMap.get(r)));
        }
        XYSeries vertAvg = this.generateVerticalROC(mod);
        this.seriesCollection.addSeries(vertAvg);
        XYSeries horizAvg = this.generateHorizontalROC(mod);
        this.seriesCollection.addSeries(horizAvg);
        XYSeries diagAvg = this.generateDiagonalROC(mod, treeMap);
        this.seriesCollection.addSeries(diagAvg);
        XYSeries pooledAvg = new XYSeries((Comparable)((Object)(String.valueOf(mod) + ": Pooled Average")), false);
        this.seriesCollection.addSeries(pooledAvg);
    }

    public void addData(TreeMap<String, TreeSet<XYPair>> fullnewData, String type) {
        for (String mod : this.modalityID) {
            TreeSet<XYPair> newData = fullnewData.get(mod);
            for (XYPair point : newData) {
                this.seriesCollection.getSeries((Comparable)((Object)(String.valueOf(mod) + ": " + type))).add(point.x, point.y);
            }
        }
    }

    private XYSeries generateDiagonalROC(String mod, TreeMap<String, TreeSet<XYPair>> treeMap) {
        XYSeries diagAvg = new XYSeries((Comparable)((Object)(String.valueOf(mod) + ": Diagonal Average")), false);
        TreeMap rotatedData = new TreeMap();
        for (String r : treeMap.keySet()) {
            rotatedData.put(r, new TreeSet());
            for (XYPair point : treeMap.get(r)) {
                double x2 = (point.x + point.y) / Math.sqrt(2.0);
                double y2 = (point.y - point.x) / Math.sqrt(2.0);
                ((TreeSet)rotatedData.get(r)).add(new XYPair(x2, y2));
            }
        }
        ArrayList<InterpolatedLine> rotatedLines = new ArrayList<InterpolatedLine>();
        for (String r : rotatedData.keySet()) {
            rotatedLines.add(new InterpolatedLine((TreeSet)rotatedData.get(r)));
        }
        double i = 0.0;
        while (i <= Math.sqrt(2.0)) {
            double avg = 0.0;
            int counter = 0;
            for (InterpolatedLine line : rotatedLines) {
                avg += line.getYatDiag(i);
                ++counter;
            }
            double x1 = i;
            double y1 = avg / (double)counter;
            double x2 = x1 * Math.cos(Math.toRadians(45.0)) - y1 * Math.sin(Math.toRadians(45.0));
            double y2 = x1 * Math.sin(Math.toRadians(45.0)) + y1 * Math.cos(Math.toRadians(45.0));
            diagAvg.add(x2, y2);
            i += 0.01;
        }
        diagAvg.add(1.0, 1.0);
        return diagAvg;
    }

    private XYSeries generateHorizontalROC(String mod) {
        XYSeries horizAvg = new XYSeries((Comparable)((Object)(String.valueOf(mod) + ": Horizontal Average")), false);
        double i = 0.0;
        while (i <= 1.01) {
            double avg = 0.0;
            int counter = 0;
            for (InterpolatedLine line : this.allLines) {
                avg += line.getXat(i);
                ++counter;
            }
            horizAvg.add(avg / (double)counter, i);
            i += 0.01;
        }
        return horizAvg;
    }

    private XYSeries generateVerticalROC(String mod) {
        XYSeries vertAvg = new XYSeries((Comparable)((Object)(String.valueOf(mod) + ": Vertical Average")), false);
        double i = 0.0;
        while (i <= 1.01) {
            double avg = 0.0;
            int counter = 0;
            for (InterpolatedLine line : this.allLines) {
                avg += line.getYat(i);
                ++counter;
            }
            vertAvg.add(i, avg / (double)counter);
            i += 0.01;
        }
        return vertAvg;
    }

    private void hideSeries(String series) {
        for (String mod : this.modalityID) {
            if (this.seriesCollection.getSeriesIndex((Comparable)((Object)(String.valueOf(mod) + ": " + series))) == -1) continue;
            this.renderer.setSeriesLinesVisible(this.seriesCollection.getSeriesIndex((Comparable)((Object)(String.valueOf(mod) + ": " + series))), false);
            this.renderer.setSeriesShapesVisible(this.seriesCollection.getSeriesIndex((Comparable)((Object)(String.valueOf(mod) + ": " + series))), false);
            this.renderer.setSeriesVisibleInLegend(this.seriesCollection.getSeriesIndex((Comparable)((Object)(String.valueOf(mod) + ": " + series))), (Boolean)false);
        }
    }

    private void showSeries(String series, boolean shapes) {
        for (String mod : this.modalityID) {
            if (this.seriesCollection.getSeriesIndex((Comparable)((Object)(String.valueOf(mod) + ": " + series))) == -1) continue;
            this.renderer.setSeriesLinesVisible(this.seriesCollection.getSeriesIndex((Comparable)((Object)(String.valueOf(mod) + ": " + series))), true);
            if (shapes) {
                this.renderer.setSeriesShapesVisible(this.seriesCollection.getSeriesIndex((Comparable)((Object)(String.valueOf(mod) + ": " + series))), true);
            }
            this.renderer.setSeriesVisibleInLegend(this.seriesCollection.getSeriesIndex((Comparable)((Object)(String.valueOf(mod) + ": " + series))), (Boolean)true);
        }
    }

    class AverageSelectListener
    implements ItemListener {
        AverageSelectListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 2) {
                ROCCurvePlot.this.vert.setSelected(false);
                ROCCurvePlot.this.horiz.setSelected(false);
                ROCCurvePlot.this.diag.setSelected(false);
                ROCCurvePlot.this.pooled.setSelected(false);
                ROCCurvePlot.this.hideSeries("Vertical Average");
                ROCCurvePlot.this.hideSeries("Horizontal Average");
                ROCCurvePlot.this.hideSeries("Diagonal Average");
                ROCCurvePlot.this.hideSeries("Pooled Average");
            } else if (e.getStateChange() == 1) {
                ROCCurvePlot.this.vert.setSelected(true);
                ROCCurvePlot.this.horiz.setSelected(true);
                ROCCurvePlot.this.diag.setSelected(true);
                ROCCurvePlot.this.pooled.setSelected(true);
                ROCCurvePlot.this.showSeries("Vertical Average", false);
                ROCCurvePlot.this.showSeries("Horizontal Average", false);
                ROCCurvePlot.this.showSeries("Diagonal Average", false);
                ROCCurvePlot.this.showSeries("Pooled Average", true);
            }
        }
    }

    class ReadersSelectListener
    implements ItemListener {
        ReadersSelectListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            block5: {
                block4: {
                    if (e.getStateChange() != 2) break block4;
                    for (JCheckBox readerBox : ROCCurvePlot.this.readerSeriesBoxes) {
                        readerBox.setSelected(false);
                    }
                    for (String title : ROCCurvePlot.this.readerSeriesTitles) {
                        ROCCurvePlot.this.hideSeries(title);
                    }
                    break block5;
                }
                if (e.getStateChange() != 1) break block5;
                for (JCheckBox readerBox : ROCCurvePlot.this.readerSeriesBoxes) {
                    readerBox.setSelected(true);
                }
                for (String title : ROCCurvePlot.this.readerSeriesTitles) {
                    ROCCurvePlot.this.showSeries(title, true);
                }
            }
        }
    }

    class SeriesSelectListener
    implements ItemListener {
        SeriesSelectListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 2) {
                if (((JCheckBox)e.getItem()).getText().equals("Vertical Average") || ((JCheckBox)e.getItem()).getText().equals("Horizontal Average") || ((JCheckBox)e.getItem()).getText().equals("Diagonal Average")) {
                    ROCCurvePlot.this.hideSeries(((JCheckBox)e.getItem()).getText());
                } else {
                    ROCCurvePlot.this.hideSeries(((JCheckBox)e.getItem()).getText());
                }
            } else if (e.getStateChange() == 1) {
                if (((JCheckBox)e.getItem()).getText().equals("Vertical Average") || ((JCheckBox)e.getItem()).getText().equals("Horizontal Average") || ((JCheckBox)e.getItem()).getText().equals("Diagonal Average")) {
                    ROCCurvePlot.this.showSeries(((JCheckBox)e.getItem()).getText(), false);
                } else {
                    ROCCurvePlot.this.showSeries(((JCheckBox)e.getItem()).getText(), true);
                }
            }
        }
    }

    class exportROCresult
    implements ActionListener {
        exportROCresult() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SimpleDateFormat dateForm = new SimpleDateFormat("yyyyMMddHHmm");
            Date currDate = new Date();
            String fileTime = dateForm.format(currDate);
            String FilePathAndName = ROCCurvePlot.this.inputfilepathandname;
            FilePathAndName = FilePathAndName.substring(0, FilePathAndName.lastIndexOf("."));
            String sFileName = String.valueOf(FilePathAndName) + "ROCcurve" + fileTime + ".csv";
            String sFileNameonly = String.valueOf(ROCCurvePlot.this.filename) + "ROCcurve" + fileTime + ".csv";
            try {
                int maxColumn = 0;
                int j = 0;
                while (j < ROCCurvePlot.this.seriesCollection.getSeriesCount()) {
                    String serisekey = (String)((Object)ROCCurvePlot.this.seriesCollection.getSeriesKey(j));
                    XYSeries seriesget = ROCCurvePlot.this.seriesCollection.getSeries((Comparable)((Object)serisekey));
                    maxColumn = Math.max(maxColumn, seriesget.getItemCount());
                    ++j;
                }
                FileWriter writer = new FileWriter(sFileName);
                writer.append("ModalityID:ReaderID");
                writer.append(',');
                writer.append("Number of points");
                writer.append(',');
                writer.append("Axises");
                int i = 0;
                while (i < maxColumn) {
                    writer.append(',');
                    ++i;
                }
                writer.append('\n');
                int j2 = 0;
                while (j2 < ROCCurvePlot.this.seriesCollection.getSeriesCount()) {
                    String tempx;
                    String serisekey = (String)((Object)ROCCurvePlot.this.seriesCollection.getSeriesKey(j2));
                    XYSeries seriesget = ROCCurvePlot.this.seriesCollection.getSeries((Comparable)((Object)serisekey));
                    writer.append(serisekey);
                    writer.append(',');
                    writer.append(Integer.toString(seriesget.getItemCount()));
                    writer.append(',');
                    writer.append("FPF");
                    writer.append(',');
                    int i2 = 0;
                    while (i2 < seriesget.getItemCount()) {
                        tempx = String.valueOf(seriesget.getX(i2));
                        writer.append(tempx);
                        writer.append(',');
                        ++i2;
                    }
                    i2 = seriesget.getItemCount();
                    while (i2 < maxColumn) {
                        writer.append(',');
                        ++i2;
                    }
                    writer.append('\n');
                    writer.append(serisekey);
                    writer.append(',');
                    writer.append(Integer.toString(seriesget.getItemCount()));
                    writer.append(',');
                    writer.append("TPF");
                    writer.append(',');
                    i2 = 0;
                    while (i2 < seriesget.getItemCount()) {
                        tempx = String.valueOf(seriesget.getY(i2));
                        writer.append(tempx);
                        writer.append(',');
                        ++i2;
                    }
                    i2 = seriesget.getItemCount();
                    while (i2 < maxColumn) {
                        writer.append(',');
                        ++i2;
                    }
                    writer.append('\n');
                    ++j2;
                }
                writer.flush();
                writer.close();
                JFrame frame = new JFrame();
                JOptionPane.showMessageDialog(frame, "ROC data has been succeed export to input file directory!\nFilename=" + sFileNameonly, "Exported", 1);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }
}

