/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.formula;

import java.util.Collections;
import java.util.Set;
import org.vikamine.kernel.formula.EvaluationData;
import org.vikamine.kernel.formula.FormulaBooleanElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FormulaBoolean
implements FormulaBooleanElement {
    public static final FormulaBoolean TRUE = new FormulaBoolean(Boolean.TRUE);
    public static final FormulaBoolean FALSE = new FormulaBoolean(Boolean.FALSE);
    private Boolean value;

    public FormulaBoolean() {
        this(Boolean.FALSE);
    }

    public FormulaBoolean(Boolean value) {
        this.setValue(value);
    }

    @Override
    public synchronized Boolean eval(EvaluationData data) {
        return this.getValue();
    }

    public String toString() {
        if (this.getValue() == null) {
            return "";
        }
        return this.getValue().toString();
    }

    public Boolean getValue() {
        return this.value;
    }

    public void setValue(Boolean value) {
        this.value = value;
    }

    @Override
    public Set getAttributes() {
        return Collections.EMPTY_SET;
    }

    @Override
    public Element createDOMNode(Document doc) {
        Element elem = doc.createElement("formula");
        elem.setAttribute("symbol", "boolean");
        elem.setAttribute("value", String.valueOf(this.value));
        return elem;
    }

    public boolean equals(Object other) {
        return this.isEqual(other);
    }

    @Override
    public boolean isEqual(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        return this.value.equals(((FormulaBoolean)other).value);
    }

    public int hashCode() {
        return this.computeHashCode();
    }

    @Override
    public int computeHashCode() {
        return this.value.hashCode();
    }
}

