/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.data;

import org.vikamine.kernel.data.AbstractDataRecord;
import org.vikamine.kernel.data.DataRecord;

public class FullDataRecord
extends AbstractDataRecord {
    protected double[] attributeValues;

    protected FullDataRecord() {
    }

    protected FullDataRecord(FullDataRecord instance) {
        this();
        this.attributeValues = instance.attributeValues;
        this.weight = instance.weight;
        this.recordSet = null;
    }

    public FullDataRecord(double weight, double[] attValues) {
        this();
        this.attributeValues = attValues;
        this.weight = weight;
        this.recordSet = null;
    }

    @Override
    public DataRecord copy() {
        FullDataRecord result = new FullDataRecord(this);
        result.recordSet = this.recordSet;
        result.setDataset(this.getDataset());
        return result;
    }

    @Override
    public void deleteAttributeAt(int position) {
        if (this.recordSet != null && this.recordSet.getNumAttributes() >= this.attributeValues.length) {
            throw new RuntimeException("Instance has access to a dataset!");
        }
        this.forceDeleteAttributeAt(position);
    }

    protected void forceDeleteAttributeAt(int position) {
        double[] newValues = new double[this.attributeValues.length - 1];
        System.arraycopy(this.attributeValues, 0, newValues, 0, position);
        if (position < this.attributeValues.length - 1) {
            System.arraycopy(this.attributeValues, position + 1, newValues, position, this.attributeValues.length - (position + 1));
        }
        this.attributeValues = newValues;
    }

    public void forceInsertAttributeAt(int position) {
        double[] newValues = new double[this.attributeValues.length + 1];
        System.arraycopy(this.attributeValues, 0, newValues, 0, position);
        newValues[position] = Double.NaN;
        System.arraycopy(this.attributeValues, position, newValues, position + 1, this.attributeValues.length - position);
        this.attributeValues = newValues;
    }

    @Override
    public int getNumAttributes() {
        return this.attributeValues.length;
    }

    @Override
    public final double getValue(int attIndex) {
        return this.attributeValues[attIndex];
    }

    @Override
    public void insertAttributeAt(int position) {
        this.forceInsertAttributeAt(position);
    }

    @Override
    public final void setValue(int attIndex, double value) {
        this.attributeValues[attIndex] = value;
    }
}

