/*
 * Decompiled with CFR 0.152.
 */
package internal.toolkit.base.core.arima;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.arima.IArimaModel;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.LogSign;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.LowerTriangularMatrix;
import jdplus.toolkit.base.core.math.matrices.SymmetricMatrix;
import jdplus.toolkit.base.core.math.polynomials.Polynomial;
import jdplus.toolkit.base.core.math.polynomials.RationalFunction;

public class MaLjungBoxFilter {
    private int m_n;
    private int m_q;
    private Polynomial m_ma;
    private double[] m_u;
    private FastMatrix m_G;
    private FastMatrix m_X;
    private FastMatrix m_V1;
    private double m_t;

    private double[] calca0(DoubleSeq w) {
        double[] a0 = new double[w.length()];
        w.copyTo(a0, 0);
        this.rma(a0);
        return a0;
    }

    private double[] calcg(double[] a0) {
        double[] g = (double[])a0.clone();
        if (this.m_q > 0) {
            int i = this.m_n - 2;
            while (i >= 0) {
                double s = 0.0;
                int j = 1;
                for (int k = i + 1; j <= this.m_q && k < this.m_n; ++j, ++k) {
                    s += this.m_ma.get(j) * g[k];
                }
                int n = i--;
                g[n] = g[n] - s;
            }
        }
        return g;
    }

    private void calcg(int m) {
        RationalFunction rf = RationalFunction.of(Polynomial.ONE, this.m_ma);
        double[] pi = rf.coefficients(this.m_n);
        FastMatrix gg = FastMatrix.square(m);
        for (int i = 0; i < m; ++i) {
            double s = 0.0;
            for (int j = i; j < this.m_n; ++j) {
                s += pi[j] * pi[j - i];
            }
            gg.set(i, 0, s);
        }
        for (int c = 1; c < m; ++c) {
            DataBlock col = gg.column(c);
            DataBlock prevcol = gg.column(c - 1);
            for (int r = c; r < m; ++r) {
                col.set(r, prevcol.get(r - 1) - pi[this.m_n - r] * pi[this.m_n - c]);
            }
        }
        SymmetricMatrix.fromLower(gg);
        this.m_G = gg;
    }

    private double[] calch(double[] g) {
        double[] h = new double[this.m_q];
        for (int i = 0; i < this.m_q; ++i) {
            for (int j = 0; j <= i; ++j) {
                int n = i;
                h[n] = h[n] + this.m_ma.get(this.m_q - i + j) * g[j];
            }
        }
        return h;
    }

    private void calcv(double[] v) {
        for (int i = 0; i < this.m_q; ++i) {
            for (int j = i; j < this.m_q; ++j) {
                int n = i;
                v[n] = v[n] + this.m_ma.get(this.m_q + i - j) * this.m_u[j];
            }
        }
        this.rma(v);
    }

    public void filter(DoubleSeq w, DataBlock wl) {
        double[] a0 = this.calca0(w);
        double[] g = this.calcg(a0);
        this.m_u = this.calch(g);
        DataBlock U = DataBlock.of(this.m_u);
        LowerTriangularMatrix.solveLx(this.m_X, U);
        LowerTriangularMatrix.solvexL(this.m_X, U);
        double[] v = new double[w.length()];
        this.calcv(v);
        wl.range(0, this.m_q).copyFrom(this.m_u, 0);
        wl.drop(this.m_q, 0).set(i -> a0[i] - v[i]);
    }

    public DoubleSeq getInitialResiduals() {
        return DoubleSeq.of((double[])this.m_u);
    }

    public double getLogDeterminant() {
        return this.m_t;
    }

    public int prepare(IArimaModel arima, int n) {
        this.m_ma = arima.getMa().asPolynomial();
        this.m_n = n;
        this.m_q = this.m_ma.degree();
        this.m_V1 = FastMatrix.square(this.m_q);
        if (this.m_q > 0) {
            this.m_V1.diagonal().set(this.m_ma.get(this.m_q));
            for (int i = 1; i < this.m_q; ++i) {
                this.m_V1.subDiagonal(i).set(this.m_ma.get(this.m_q - i));
            }
        }
        this.calcg(this.m_q);
        this.m_X = SymmetricMatrix.XtSX(this.m_G, this.m_V1);
        this.m_X.diagonal().add(1.0);
        SymmetricMatrix.lcholesky(this.m_X);
        this.m_t = 2.0 * LogSign.of((DoubleSeq)this.m_X.diagonal()).getValue();
        return n + this.m_q;
    }

    void rma(double[] a) {
        if (this.m_q > 0) {
            int j;
            double s;
            int i = 1;
            while (i < this.m_q) {
                s = 0.0;
                for (j = 1; j <= i; ++j) {
                    s += this.m_ma.get(j) * a[i - j];
                }
                int n = i++;
                a[n] = a[n] - s;
            }
            i = this.m_q;
            while (i < a.length) {
                s = 0.0;
                for (j = 1; j <= this.m_q; ++j) {
                    s += this.m_ma.get(j) * a[i - j];
                }
                int n = i++;
                a[n] = a[n] - s;
            }
        }
    }
}

